/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.feed;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;

public class FeedIndexingFilter
implements IndexingFilter {
    public static final String dateFormatStr = "yyyyMMddHHmm";
    private Configuration conf;
    private static final String PUBLISHED_DATE = "publishedDate";
    private static final String UPDATED_DATE = "updatedDate";

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        Date date;
        ParseData parseData = parse.getData();
        Metadata parseMeta = parseData.getParseMeta();
        String[] authors = parseMeta.getValues("author");
        String[] tags = parseMeta.getValues("tag");
        String published = parseMeta.get("published");
        String updated = parseMeta.get("updated");
        String feed = parseMeta.get("feed");
        if (authors != null) {
            for (String author : authors) {
                doc.add("author", (Object)author);
            }
        }
        if (tags != null) {
            for (String tag : tags) {
                doc.add("tag", (Object)tag);
            }
        }
        if (feed != null) {
            doc.add("feed", (Object)feed);
        }
        if (published != null) {
            date = new Date(Long.parseLong(published));
            doc.add(PUBLISHED_DATE, (Object)date);
        }
        if (updated != null) {
            date = new Date(Long.parseLong(updated));
            doc.add(UPDATED_DATE, (Object)date);
        }
        return doc;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }
}

