/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.ParsedScrollId;
import org.opensearch.action.search.SearchActionListener;
import org.opensearch.action.search.SearchPhase;
import org.opensearch.action.search.SearchPhaseController;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollAsyncAction;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.AtomicArray;
import org.opensearch.search.fetch.QueryFetchSearchResult;
import org.opensearch.search.fetch.ScrollQueryFetchSearchResult;
import org.opensearch.search.internal.InternalScrollSearchRequest;
import org.opensearch.transport.Transport;

final class SearchScrollQueryAndFetchAsyncAction
extends SearchScrollAsyncAction<ScrollQueryFetchSearchResult> {
    private final SearchTask task;
    private final AtomicArray<QueryFetchSearchResult> queryFetchResults;

    SearchScrollQueryAndFetchAsyncAction(Logger logger, ClusterService clusterService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, SearchScrollRequest request, SearchTask task, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        super(scrollId, logger, clusterService.state().nodes(), listener, searchPhaseController, request, searchTransportService);
        this.task = task;
        this.queryFetchResults = new AtomicArray(scrollId.getContext().length);
    }

    @Override
    protected void executeInitialPhase(Transport.Connection connection, InternalScrollSearchRequest internalRequest, SearchActionListener<ScrollQueryFetchSearchResult> searchActionListener) {
        this.searchTransportService.sendExecuteScrollFetch(connection, internalRequest, this.task, searchActionListener);
    }

    @Override
    protected SearchPhase moveToNextPhase(BiFunction<String, String, DiscoveryNode> clusterNodeLookup) {
        return this.sendResponsePhase(this.searchPhaseController.reducedScrollQueryPhase(this.queryFetchResults.asList()), this.queryFetchResults);
    }

    @Override
    protected void onFirstPhaseResult(int shardId, ScrollQueryFetchSearchResult result) {
        this.queryFetchResults.setOnce(shardId, result.result());
    }
}

