/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public class StoreStats
implements Writeable,
ToXContentFragment {
    public static final long UNKNOWN_RESERVED_BYTES = -1L;
    public static final Version RESERVED_BYTES_VERSION = LegacyESVersion.V_7_9_0;
    private long sizeInBytes;
    private long reservedSize;

    public StoreStats() {
    }

    public StoreStats(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
        if (in.getVersion().before(LegacyESVersion.V_6_0_0_alpha1)) {
            in.readVLong();
        }
        this.reservedSize = in.getVersion().onOrAfter(RESERVED_BYTES_VERSION) ? in.readZLong() : -1L;
    }

    public StoreStats(long sizeInBytes, long reservedSize) {
        assert (reservedSize == -1L || reservedSize >= 0L) : reservedSize;
        this.sizeInBytes = sizeInBytes;
        this.reservedSize = reservedSize;
    }

    public void add(StoreStats stats) {
        if (stats == null) {
            return;
        }
        this.sizeInBytes += stats.sizeInBytes;
        this.reservedSize = StoreStats.ignoreIfUnknown(this.reservedSize) + StoreStats.ignoreIfUnknown(stats.reservedSize);
    }

    private static long ignoreIfUnknown(long reservedSize) {
        return reservedSize == -1L ? 0L : reservedSize;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue size() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public ByteSizeValue getSize() {
        return this.size();
    }

    public ByteSizeValue getReservedSize() {
        return new ByteSizeValue(this.reservedSize);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
        if (out.getVersion().before(LegacyESVersion.V_6_0_0_alpha1)) {
            out.writeVLong(0L);
        }
        if (out.getVersion().onOrAfter(RESERVED_BYTES_VERSION)) {
            out.writeZLong(this.reservedSize);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("store");
        builder.humanReadableField("size_in_bytes", "size", (Object)this.size());
        builder.humanReadableField("reserved_in_bytes", "reserved", (Object)this.getReservedSize());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String STORE = "store";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";
        static final String RESERVED = "reserved";
        static final String RESERVED_IN_BYTES = "reserved_in_bytes";

        Fields() {
        }
    }
}

