/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.transport.TransportStatus;

public class Header {
    private static final String RESPONSE_NAME = "NO_ACTION_NAME_FOR_RESPONSES";
    private final int networkMessageSize;
    private final Version version;
    private final long requestId;
    private final byte status;
    String actionName;
    Tuple<Map<String, String>, Map<String, Set<String>>> headers;
    Set<String> features;

    Header(int networkMessageSize, long requestId, byte status, Version version) {
        this.networkMessageSize = networkMessageSize;
        this.version = version;
        this.requestId = requestId;
        this.status = status;
    }

    public int getNetworkMessageSize() {
        return this.networkMessageSize;
    }

    Version getVersion() {
        return this.version;
    }

    long getRequestId() {
        return this.requestId;
    }

    byte getStatus() {
        return this.status;
    }

    boolean isRequest() {
        return TransportStatus.isRequest(this.status);
    }

    boolean isResponse() {
        return !TransportStatus.isRequest(this.status);
    }

    boolean isError() {
        return TransportStatus.isError(this.status);
    }

    boolean isHandshake() {
        return TransportStatus.isHandshake(this.status);
    }

    boolean isCompressed() {
        return TransportStatus.isCompress(this.status);
    }

    public String getActionName() {
        return this.actionName;
    }

    boolean needsToReadVariableHeader() {
        return this.headers == null;
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    Tuple<Map<String, String>, Map<String, Set<String>>> getHeaders() {
        return this.headers;
    }

    void finishParsingHeader(StreamInput input) throws IOException {
        this.headers = ThreadContext.readHeadersFromStream(input);
        if (this.isRequest()) {
            String[] featuresFound;
            this.features = this.version.onOrAfter(LegacyESVersion.V_6_3_0) ? ((featuresFound = input.readStringArray()).length == 0 ? Collections.emptySet() : Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(featuresFound)))) : Collections.emptySet();
            this.actionName = input.readString();
        } else {
            this.actionName = RESPONSE_NAME;
        }
    }

    public String toString() {
        return "Header{" + this.networkMessageSize + "}{" + this.version + "}{" + this.requestId + "}{" + this.isRequest() + "}{" + this.isError() + "}{" + this.isHandshake() + "}{" + this.isCompressed() + "}{" + this.actionName + "}";
    }
}

