/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.errors.InvalidFetchSizeException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupCoordinatorShard;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.metrics.CoordinatorRuntimeMetrics;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetrics;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.group.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.group.runtime.CoordinatorRuntime;
import org.apache.kafka.coordinator.group.runtime.CoordinatorShardBuilderSupplier;
import org.apache.kafka.coordinator.group.runtime.MultiThreadedEventProcessor;
import org.apache.kafka.coordinator.group.runtime.PartitionWriter;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.FutureUtils;
import org.apache.kafka.server.util.timer.Timer;
import org.slf4j.Logger;

public class GroupCoordinatorService
implements GroupCoordinator {
    private final Logger log;
    private final GroupCoordinatorConfig config;
    private final CoordinatorRuntime<GroupCoordinatorShard, Record> runtime;
    private final GroupCoordinatorMetrics groupCoordinatorMetrics;
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private volatile int numPartitions = -1;

    GroupCoordinatorService(LogContext logContext, GroupCoordinatorConfig config, CoordinatorRuntime<GroupCoordinatorShard, Record> runtime, GroupCoordinatorMetrics groupCoordinatorMetrics) {
        this.log = logContext.logger(CoordinatorLoader.class);
        this.config = config;
        this.runtime = runtime;
        this.groupCoordinatorMetrics = groupCoordinatorMetrics;
    }

    private void throwIfNotActive() {
        if (!this.isActive.get()) {
            throw Errors.COORDINATOR_NOT_AVAILABLE.exception();
        }
    }

    private TopicPartition topicPartitionFor(String groupId) {
        return new TopicPartition("__consumer_offsets", this.partitionFor(groupId));
    }

    @Override
    public int partitionFor(String groupId) {
        this.throwIfNotActive();
        return Utils.abs((int)groupId.hashCode()) % this.numPartitions;
    }

    @Override
    public CompletableFuture<ConsumerGroupHeartbeatResponseData> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        return this.runtime.scheduleWriteOperation("consumer-group-heartbeat", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.consumerGroupHeartbeat(context, request)).exceptionally(exception -> {
            if (exception instanceof UnknownTopicOrPartitionException || exception instanceof NotEnoughReplicasException || exception instanceof TimeoutException) {
                return new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
            }
            if (exception instanceof NotLeaderOrFollowerException || exception instanceof KafkaStorageException) {
                return new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NOT_COORDINATOR.code());
            }
            if (exception instanceof RecordTooLargeException || exception instanceof RecordBatchTooLargeException || exception instanceof InvalidFetchSizeException) {
                return new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code());
            }
            return new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.forException((Throwable)exception).code()).setErrorMessage(exception.getMessage());
        });
    }

    @Override
    public CompletableFuture<JoinGroupResponseData> joinGroup(RequestContext context, JoinGroupRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new JoinGroupResponseData().setMemberId(request.memberId()).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new JoinGroupResponseData().setMemberId(request.memberId()).setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        CompletableFuture<JoinGroupResponseData> responseFuture = new CompletableFuture<JoinGroupResponseData>();
        this.runtime.scheduleWriteOperation("classic-group-join", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.classicGroupJoin(context, request, responseFuture)).exceptionally(exception -> {
            if (!(exception instanceof KafkaException)) {
                this.log.error("JoinGroup request {} hit an unexpected exception: {}", (Object)request, (Object)exception.getMessage());
            }
            if (!responseFuture.isDone()) {
                responseFuture.complete(new JoinGroupResponseData().setErrorCode(Errors.forException((Throwable)exception).code()));
            }
            return null;
        });
        return responseFuture;
    }

    @Override
    public CompletableFuture<SyncGroupResponseData> syncGroup(RequestContext context, SyncGroupRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new SyncGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new SyncGroupResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        CompletableFuture<SyncGroupResponseData> responseFuture = new CompletableFuture<SyncGroupResponseData>();
        this.runtime.scheduleWriteOperation("classic-group-sync", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.classicGroupSync(context, request, responseFuture)).exceptionally(exception -> {
            if (!(exception instanceof KafkaException)) {
                this.log.error("SyncGroup request {} hit an unexpected exception: {}", (Object)request, (Object)exception.getMessage());
            }
            if (!responseFuture.isDone()) {
                responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.forException((Throwable)exception).code()));
            }
            return null;
        });
        return responseFuture;
    }

    @Override
    public CompletableFuture<HeartbeatResponseData> heartbeat(RequestContext context, HeartbeatRequestData request) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new HeartbeatResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new HeartbeatResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        return this.runtime.scheduleReadOperation("classic-group-heartbeat", this.topicPartitionFor(request.groupId()), (coordinator, __) -> coordinator.classicGroupHeartbeat(context, request)).exceptionally(exception -> {
            if (!(exception instanceof KafkaException)) {
                this.log.error("Heartbeat request {} hit an unexpected exception: {}", (Object)request, (Object)exception.getMessage());
            }
            if (exception instanceof CoordinatorLoadInProgressException) {
                return new HeartbeatResponseData().setErrorCode(Errors.NONE.code());
            }
            return new HeartbeatResponseData().setErrorCode(Errors.forException((Throwable)exception).code());
        });
    }

    @Override
    public CompletableFuture<LeaveGroupResponseData> leaveGroup(RequestContext context, LeaveGroupRequestData request) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new LeaveGroupResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        return this.runtime.scheduleWriteOperation("classic-group-leave", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.classicGroupLeave(context, request)).exceptionally(exception -> {
            if (!(exception instanceof KafkaException)) {
                this.log.error("LeaveGroup request {} hit an unexpected exception: {}", (Object)request, (Object)exception.getMessage());
            }
            if (exception instanceof UnknownMemberIdException) {
                List memberResponses = request.members().stream().map(member -> new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code())).collect(Collectors.toList());
                return new LeaveGroupResponseData().setMembers(memberResponses);
            }
            return new LeaveGroupResponseData().setErrorCode(Errors.forException((Throwable)exception).code());
        });
    }

    @Override
    public CompletableFuture<ListGroupsResponseData> listGroups(RequestContext context, ListGroupsRequestData request) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        CompletableFuture<ListGroupsResponseData> future = new CompletableFuture<ListGroupsResponseData>();
        ArrayList results = new ArrayList();
        Set<TopicPartition> existingPartitionSet = this.runtime.partitions();
        AtomicInteger cnt = new AtomicInteger(existingPartitionSet.size());
        if (existingPartitionSet.isEmpty()) {
            return CompletableFuture.completedFuture(new ListGroupsResponseData());
        }
        for (TopicPartition tp : existingPartitionSet) {
            this.runtime.scheduleReadOperation("list-groups", tp, (coordinator, lastCommittedOffset) -> coordinator.listGroups(request.statesFilter(), lastCommittedOffset)).handle((groups, exception) -> {
                if (exception == null) {
                    List list = results;
                    synchronized (list) {
                        results.addAll(groups);
                    }
                } else if (!(exception instanceof NotCoordinatorException)) {
                    future.complete(new ListGroupsResponseData().setErrorCode(Errors.forException((Throwable)exception).code()));
                }
                if (cnt.decrementAndGet() == 0) {
                    future.complete(new ListGroupsResponseData().setGroups(results));
                }
                return null;
            });
        }
        return future;
    }

    @Override
    public CompletableFuture<List<ConsumerGroupDescribeResponseData.DescribedGroup>> consumerGroupDescribe(RequestContext context, List<String> groupIds) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(ConsumerGroupDescribeRequest.getErrorDescribedGroupList(groupIds, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        ArrayList futures = new ArrayList(groupIds.size());
        HashMap<TopicPartition, List> groupsByTopicPartition = new HashMap<TopicPartition, List>();
        groupIds.forEach(groupId -> {
            if (GroupCoordinatorService.isGroupIdNotEmpty(groupId)) {
                groupsByTopicPartition.computeIfAbsent(this.topicPartitionFor((String)groupId), __ -> new ArrayList()).add(groupId);
            } else {
                futures.add(CompletableFuture.completedFuture(Collections.singletonList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(null).setErrorCode(Errors.INVALID_GROUP_ID.code()))));
            }
        });
        groupsByTopicPartition.forEach((topicPartition, groupList) -> {
            CompletionStage future = this.runtime.scheduleReadOperation("consumer-group-describe", (TopicPartition)topicPartition, (coordinator, lastCommittedOffset) -> coordinator.consumerGroupDescribe(groupIds, lastCommittedOffset)).exceptionally(exception -> {
                if (!(exception instanceof KafkaException)) {
                    this.log.error("ConsumerGroupDescribe request {} hit an unexpected exception: {}.", groupList, (Object)exception.getMessage());
                }
                return ConsumerGroupDescribeRequest.getErrorDescribedGroupList((List)groupList, (Errors)Errors.forException((Throwable)exception));
            });
            futures.add(future);
        });
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return allFutures.thenApply(v -> {
            ArrayList res = new ArrayList();
            futures.forEach(future -> res.addAll((Collection)future.join()));
            return res;
        });
    }

    @Override
    public CompletableFuture<List<DescribeGroupsResponseData.DescribedGroup>> describeGroups(RequestContext context, List<String> groupIds) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(DescribeGroupsRequest.getErrorDescribedGroupList(groupIds, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        ArrayList futures = new ArrayList(groupIds.size());
        HashMap<TopicPartition, List> groupsByTopicPartition = new HashMap<TopicPartition, List>();
        groupIds.forEach(groupId -> {
            if (groupId == null) {
                futures.add(CompletableFuture.completedFuture(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId(null).setErrorCode(Errors.INVALID_GROUP_ID.code()))));
            } else {
                TopicPartition topicPartition = this.topicPartitionFor((String)groupId);
                groupsByTopicPartition.computeIfAbsent(topicPartition, __ -> new ArrayList()).add(groupId);
            }
        });
        groupsByTopicPartition.forEach((topicPartition, groupList) -> {
            CompletionStage future = this.runtime.scheduleReadOperation("describe-groups", (TopicPartition)topicPartition, (coordinator, lastCommittedOffset) -> coordinator.describeGroups(context, (List<String>)groupList, lastCommittedOffset)).exceptionally(exception -> {
                if (!(exception instanceof KafkaException)) {
                    this.log.error("DescribeGroups request {} hit an unexpected exception: {}", groupList, (Object)exception.getMessage());
                }
                return DescribeGroupsRequest.getErrorDescribedGroupList((List)groupList, (Errors)Errors.forException((Throwable)exception));
            });
            futures.add(future);
        });
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return allFutures.thenApply(v -> {
            ArrayList res = new ArrayList();
            futures.forEach(future -> res.addAll((Collection)future.join()));
            return res;
        });
    }

    @Override
    public CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> deleteGroups(RequestContext context, List<String> groupIds, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(DeleteGroupsRequest.getErrorResultCollection(groupIds, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        ArrayList futures = new ArrayList(groupIds.size());
        HashMap<TopicPartition, List> groupsByTopicPartition = new HashMap<TopicPartition, List>();
        groupIds.forEach(groupId -> {
            if (groupId == null) {
                futures.add(CompletableFuture.completedFuture(DeleteGroupsRequest.getErrorResultCollection(Collections.singletonList(null), (Errors)Errors.INVALID_GROUP_ID)));
            } else {
                TopicPartition topicPartition = this.topicPartitionFor((String)groupId);
                groupsByTopicPartition.computeIfAbsent(topicPartition, __ -> new ArrayList()).add(groupId);
            }
        });
        groupsByTopicPartition.forEach((topicPartition, groupList) -> {
            CompletionStage future = this.runtime.scheduleWriteOperation("delete-groups", (TopicPartition)topicPartition, Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.deleteGroups(context, (List<String>)groupList)).exceptionally(exception -> DeleteGroupsRequest.getErrorResultCollection((List)groupList, (Errors)GroupCoordinatorService.normalizeException(exception)));
            futures.add(future);
        });
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return allFutures.thenApply(__ -> {
            DeleteGroupsResponseData.DeletableGroupResultCollection res = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            futures.forEach(future -> ((DeleteGroupsResponseData.DeletableGroupResultCollection)future.join()).forEach(result -> res.add((ImplicitLinkedHashCollection.Element)result.duplicate())));
            return res;
        });
    }

    @Override
    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (request.groupId() == null) {
            return CompletableFuture.completedFuture(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        if (requireStable) {
            return this.runtime.scheduleWriteOperation("fetch-offsets", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> new CoordinatorResult(Collections.emptyList(), coordinator.fetchOffsets(request, Long.MAX_VALUE)));
        }
        return this.runtime.scheduleReadOperation("fetch-offsets", this.topicPartitionFor(request.groupId()), (coordinator, offset) -> coordinator.fetchOffsets(request, offset));
    }

    @Override
    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchAllOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (request.groupId() == null) {
            return CompletableFuture.completedFuture(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        if (requireStable) {
            return this.runtime.scheduleWriteOperation("fetch-all-offsets", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> new CoordinatorResult(Collections.emptyList(), coordinator.fetchAllOffsets(request, Long.MAX_VALUE)));
        }
        return this.runtime.scheduleReadOperation("fetch-all-offsets", this.topicPartitionFor(request.groupId()), (coordinator, offset) -> coordinator.fetchAllOffsets(request, offset));
    }

    @Override
    public CompletableFuture<OffsetCommitResponseData> commitOffsets(RequestContext context, OffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(OffsetCommitRequest.getErrorResponse((OffsetCommitRequestData)request, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        if (request.groupId() == null) {
            return CompletableFuture.completedFuture(OffsetCommitRequest.getErrorResponse((OffsetCommitRequestData)request, (Errors)Errors.INVALID_GROUP_ID));
        }
        return this.runtime.scheduleWriteOperation("commit-offset", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.commitOffset(context, request)).exceptionally(exception -> OffsetCommitRequest.getErrorResponse((OffsetCommitRequestData)request, (Errors)GroupCoordinatorService.normalizeException(exception)));
    }

    @Override
    public CompletableFuture<TxnOffsetCommitResponseData> commitTransactionalOffsets(RequestContext context, TxnOffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(TxnOffsetCommitRequest.getErrorResponse((TxnOffsetCommitRequestData)request, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(TxnOffsetCommitRequest.getErrorResponse((TxnOffsetCommitRequestData)request, (Errors)Errors.INVALID_GROUP_ID));
        }
        return this.runtime.scheduleTransactionalWriteOperation("txn-commit-offset", this.topicPartitionFor(request.groupId()), request.transactionalId(), request.producerId(), request.producerEpoch(), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.commitTransactionalOffset(context, request)).exceptionally(exception -> TxnOffsetCommitRequest.getErrorResponse((TxnOffsetCommitRequestData)request, (Errors)GroupCoordinatorService.normalizeException(exception)));
    }

    @Override
    public CompletableFuture<OffsetDeleteResponseData> deleteOffsets(RequestContext context, OffsetDeleteRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new OffsetDeleteResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new OffsetDeleteResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        return this.runtime.scheduleWriteOperation("delete-offsets", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.deleteOffsets(context, request)).exceptionally(exception -> new OffsetDeleteResponseData().setErrorCode(GroupCoordinatorService.normalizeException(exception).code()));
    }

    @Override
    public CompletableFuture<Void> completeTransaction(TopicPartition tp, long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result, Duration timeout) {
        if (!this.isActive.get()) {
            return FutureUtils.failedFuture((Throwable)Errors.COORDINATOR_NOT_AVAILABLE.exception());
        }
        if (!tp.topic().equals("__consumer_offsets")) {
            return FutureUtils.failedFuture((Throwable)new IllegalStateException("Completing a transaction for " + tp + " is not expected"));
        }
        return this.runtime.scheduleTransactionCompletion("write-txn-marker", tp, producerId, producerEpoch, coordinatorEpoch, result, timeout);
    }

    @Override
    public void onTransactionCompleted(long producerId, Iterable<TopicPartition> partitions, TransactionResult transactionResult) {
        this.throwIfNotActive();
        throw new IllegalStateException("onTransactionCompleted is not supported.");
    }

    @Override
    public void onPartitionsDeleted(List<TopicPartition> topicPartitions, BufferSupplier bufferSupplier) {
        this.throwIfNotActive();
    }

    @Override
    public void onElection(int groupMetadataPartitionIndex, int groupMetadataPartitionLeaderEpoch) {
        this.throwIfNotActive();
        this.runtime.scheduleLoadOperation(new TopicPartition("__consumer_offsets", groupMetadataPartitionIndex), groupMetadataPartitionLeaderEpoch);
    }

    @Override
    public void onResignation(int groupMetadataPartitionIndex, OptionalInt groupMetadataPartitionLeaderEpoch) {
        this.throwIfNotActive();
        this.runtime.scheduleUnloadOperation(new TopicPartition("__consumer_offsets", groupMetadataPartitionIndex), groupMetadataPartitionLeaderEpoch);
    }

    @Override
    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.throwIfNotActive();
        this.runtime.onNewMetadataImage(newImage, delta);
    }

    @Override
    public Properties groupMetadataTopicConfigs() {
        Properties properties = new Properties();
        properties.put("cleanup.policy", "compact");
        properties.put("compression.type", BrokerCompressionType.PRODUCER.name);
        properties.put("segment.bytes", String.valueOf(this.config.offsetsTopicSegmentBytes));
        return properties;
    }

    @Override
    public void startup(IntSupplier groupMetadataTopicPartitionCount) {
        if (!this.isActive.compareAndSet(false, true)) {
            this.log.warn("Group coordinator is already running.");
            return;
        }
        this.log.info("Starting up.");
        this.numPartitions = groupMetadataTopicPartitionCount.getAsInt();
        this.isActive.set(true);
        this.log.info("Startup complete.");
    }

    @Override
    public void shutdown() {
        if (!this.isActive.compareAndSet(true, false)) {
            this.log.warn("Group coordinator is already shutting down.");
            return;
        }
        this.log.info("Shutting down.");
        this.isActive.set(false);
        Utils.closeQuietly(this.runtime, (String)"coordinator runtime");
        Utils.closeQuietly((AutoCloseable)this.groupCoordinatorMetrics, (String)"group coordinator metrics");
        this.log.info("Shutdown complete.");
    }

    private static boolean isGroupIdNotEmpty(String groupId) {
        return groupId != null && !groupId.isEmpty();
    }

    private static Errors normalizeException(Throwable exception) {
        if (exception instanceof UnknownTopicOrPartitionException || exception instanceof NotEnoughReplicasException || exception instanceof TimeoutException) {
            return Errors.COORDINATOR_NOT_AVAILABLE;
        }
        if (exception instanceof NotLeaderOrFollowerException || exception instanceof KafkaStorageException) {
            return Errors.NOT_COORDINATOR;
        }
        if (exception instanceof RecordTooLargeException || exception instanceof RecordBatchTooLargeException || exception instanceof InvalidFetchSizeException) {
            return Errors.UNKNOWN_SERVER_ERROR;
        }
        return Errors.forException((Throwable)exception);
    }

    public static class Builder {
        private final int nodeId;
        private final GroupCoordinatorConfig config;
        private PartitionWriter<Record> writer;
        private CoordinatorLoader<Record> loader;
        private Time time;
        private Timer timer;
        private CoordinatorRuntimeMetrics coordinatorRuntimeMetrics;
        private GroupCoordinatorMetrics groupCoordinatorMetrics;

        public Builder(int nodeId, GroupCoordinatorConfig config) {
            this.nodeId = nodeId;
            this.config = config;
        }

        public Builder withWriter(PartitionWriter<Record> writer) {
            this.writer = writer;
            return this;
        }

        public Builder withLoader(CoordinatorLoader<Record> loader) {
            this.loader = loader;
            return this;
        }

        public Builder withTime(Time time) {
            this.time = time;
            return this;
        }

        public Builder withTimer(Timer timer) {
            this.timer = timer;
            return this;
        }

        public Builder withCoordinatorRuntimeMetrics(CoordinatorRuntimeMetrics coordinatorRuntimeMetrics) {
            this.coordinatorRuntimeMetrics = coordinatorRuntimeMetrics;
            return this;
        }

        public Builder withGroupCoordinatorMetrics(GroupCoordinatorMetrics groupCoordinatorMetrics) {
            this.groupCoordinatorMetrics = groupCoordinatorMetrics;
            return this;
        }

        public GroupCoordinatorService build() {
            if (this.config == null) {
                throw new IllegalArgumentException("Config must be set.");
            }
            if (this.writer == null) {
                throw new IllegalArgumentException("Writer must be set.");
            }
            if (this.loader == null) {
                throw new IllegalArgumentException("Loader must be set.");
            }
            if (this.time == null) {
                throw new IllegalArgumentException("Time must be set.");
            }
            if (this.timer == null) {
                throw new IllegalArgumentException("Timer must be set.");
            }
            if (this.coordinatorRuntimeMetrics == null) {
                throw new IllegalArgumentException("CoordinatorRuntimeMetrics must be set.");
            }
            if (this.groupCoordinatorMetrics == null) {
                throw new IllegalArgumentException("GroupCoordinatorMetrics must be set.");
            }
            String logPrefix = String.format("GroupCoordinator id=%d", this.nodeId);
            LogContext logContext = new LogContext(String.format("[%s] ", logPrefix));
            CoordinatorShardBuilderSupplier supplier = () -> new GroupCoordinatorShard.Builder(this.config);
            MultiThreadedEventProcessor processor = new MultiThreadedEventProcessor(logContext, "group-coordinator-event-processor-", this.config.numThreads, this.time, this.coordinatorRuntimeMetrics);
            CoordinatorRuntime<GroupCoordinatorShard, Record> runtime = new CoordinatorRuntime.Builder().withTime(this.time).withTimer(this.timer).withLogPrefix(logPrefix).withLogContext(logContext).withEventProcessor(processor).withPartitionWriter(this.writer).withLoader(this.loader).withCoordinatorShardBuilderSupplier(supplier).withTime(this.time).withDefaultWriteTimeOut(Duration.ofMillis(this.config.offsetCommitTimeoutMs)).withCoordinatorRuntimeMetrics(this.coordinatorRuntimeMetrics).withCoordinatorMetrics(this.groupCoordinatorMetrics).build();
            return new GroupCoordinatorService(logContext, this.config, runtime, this.groupCoordinatorMetrics);
        }
    }
}

