/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.rabbit;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.IndexWriterParams;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.indexer.NutchField;
import org.apache.nutch.indexwriter.rabbit.RabbitDocument;
import org.apache.nutch.indexwriter.rabbit.RabbitMessage;
import org.apache.nutch.rabbitmq.RabbitMQClient;
import org.apache.nutch.rabbitmq.RabbitMQMessage;
import org.apache.nutch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitIndexWriter
implements IndexWriter {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitIndexWriter.class);
    private String uri;
    private String exchange;
    private String exchangeOptions;
    private String routingKey;
    private int commitSize;
    private String commitMode;
    private String headersStatic;
    private List<String> headersDynamic;
    private boolean binding;
    private String bindingArguments;
    private String queueName;
    private String queueOptions;
    private Configuration config;
    private RabbitMessage rabbitMessage = new RabbitMessage();
    private RabbitMQClient client;

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public void open(Configuration conf, String name) throws IOException {
    }

    public void open(IndexWriterParams parameters) throws IOException {
        this.exchange = (String)parameters.get((Object)"exchange.name");
        this.routingKey = (String)parameters.get((Object)"routingkey");
        this.commitSize = parameters.getInt("commit.size", 250);
        this.commitMode = parameters.get("commit.mode", "multiple");
        this.headersStatic = parameters.get("headers.static", "");
        this.headersDynamic = Arrays.asList(parameters.getStrings("headers.dynamic", new String[]{""}));
        this.uri = (String)parameters.get((Object)"server.uri");
        this.client = new RabbitMQClient(this.uri);
        this.client.openChannel();
        this.binding = parameters.getBoolean("binding", false);
        if (this.binding) {
            this.queueName = (String)parameters.get((Object)"queue.name");
            this.queueOptions = (String)parameters.get((Object)"queue.options");
            this.exchangeOptions = (String)parameters.get((Object)"exchange.options");
            this.bindingArguments = parameters.get("binding.arguments", "");
            this.client.bind(this.exchange, this.exchangeOptions, this.queueName, this.queueOptions, this.routingKey, this.bindingArguments);
        }
    }

    public void write(NutchDocument doc) throws IOException {
        RabbitDocument rabbitDocument = new RabbitDocument();
        for (Map.Entry e : doc) {
            RabbitDocument.RabbitDocumentField field = new RabbitDocument.RabbitDocumentField((String)e.getKey(), ((NutchField)e.getValue()).getWeight(), ((NutchField)e.getValue()).getValues());
            rabbitDocument.addField(field);
        }
        rabbitDocument.setDocumentBoost(doc.getWeight());
        this.rabbitMessage.addDocToWrite(rabbitDocument);
        if (this.rabbitMessage.size() >= this.commitSize) {
            this.commit();
        }
    }

    public void delete(String url) throws IOException {
        this.rabbitMessage.addDocToDelete(url);
        if (this.rabbitMessage.size() >= this.commitSize) {
            this.commit();
        }
    }

    public void update(NutchDocument doc) throws IOException {
        RabbitDocument rabbitDocument = new RabbitDocument();
        for (Map.Entry e : doc) {
            RabbitDocument.RabbitDocumentField field = new RabbitDocument.RabbitDocumentField((String)e.getKey(), ((NutchField)e.getValue()).getWeight(), ((NutchField)e.getValue()).getValues());
            rabbitDocument.addField(field);
        }
        rabbitDocument.setDocumentBoost(doc.getWeight());
        this.rabbitMessage.addDocToUpdate(rabbitDocument);
        if (this.rabbitMessage.size() >= this.commitSize) {
            this.commit();
        }
    }

    public void commit() throws IOException {
        if (!this.rabbitMessage.isEmpty()) {
            if ("single".equals(this.commitMode)) {
                RabbitMQMessage message;
                for (String s : this.rabbitMessage.getDocsToDelete()) {
                    message = new RabbitMQMessage();
                    message.setBody(s.getBytes());
                    message.setHeaders(this.headersStatic);
                    message.addHeader("action", (Object)"delete");
                    this.client.publish(this.exchange, this.routingKey, message);
                }
                for (RabbitDocument rabbitDocument : this.rabbitMessage.getDocsToUpdate()) {
                    message = new RabbitMQMessage();
                    message.setBody(rabbitDocument.getBytes());
                    this.addHeaders(message, rabbitDocument);
                    message.addHeader("action", (Object)"update");
                    this.client.publish(this.exchange, this.routingKey, message);
                }
                for (RabbitDocument rabbitDocument : this.rabbitMessage.getDocsToWrite()) {
                    message = new RabbitMQMessage();
                    message.setBody(rabbitDocument.getBytes());
                    this.addHeaders(message, rabbitDocument);
                    message.addHeader("action", (Object)"write");
                    this.client.publish(this.exchange, this.routingKey, message);
                }
            } else {
                RabbitMQMessage message = new RabbitMQMessage();
                message.setBody(this.rabbitMessage.getBytes());
                message.setHeaders(this.headersStatic);
                this.client.publish(this.exchange, this.routingKey, message);
            }
        }
        this.rabbitMessage.clear();
    }

    public void close() throws IOException {
        this.commit();
        this.client.close();
    }

    public Map<String, Map.Entry<String, Object>> describe() {
        LinkedHashMap<String, Map.Entry<String, Object>> properties = new LinkedHashMap<String, Map.Entry<String, Object>>();
        Pattern maskPasswordPattern = Pattern.compile("^amqp://[^:]+:([^@]+)@");
        properties.put("server.uri", new AbstractMap.SimpleEntry<String, String>("URI with connection parameters in the form amqp://<username>:<password>@<hostname>:<port>/<virtualHost>", StringUtil.mask((String)this.uri, (Pattern)maskPasswordPattern, (char)'*')));
        properties.put("binding", new AbstractMap.SimpleEntry<String, Boolean>("Whether the relationship between an exchange and a queue is created automatically. NOTE: Binding between exchanges is not supported.", this.binding));
        properties.put("binding.arguments", new AbstractMap.SimpleEntry<String, String>("Arguments used in binding. It must have the form key1=value1,key2=value2. This value is only used when the exchange's type is headers and the value of binding property is true. In other cases is ignored.", this.bindingArguments));
        properties.put("exchange.name", new AbstractMap.SimpleEntry<String, String>("Name for the exchange where the messages will be sent.", this.exchange));
        properties.put("exchange.options", new AbstractMap.SimpleEntry<String, String>("Options used when the exchange is created. Only used when the value of binding property is true. It must have the form type=<type>,durable=<durable>", this.exchangeOptions));
        properties.put("queue.name", new AbstractMap.SimpleEntry<String, String>("Name of the queue used to create the binding. Only used when the value of binding property is true.", this.queueName));
        properties.put("queue.options", new AbstractMap.SimpleEntry<String, String>("Options used when the queue is created. Only used when the value of binding property is true. It must have the form durable=<durable>,exclusive=<exclusive>,auto-delete=<auto-delete>,arguments=<arguments>", this.queueOptions));
        properties.put("routingkey", new AbstractMap.SimpleEntry<String, String>("The routing key used to route messages in the exchange. It only makes sense when the exchange type is topic or direct.", this.routingKey));
        properties.put("commit.mode", new AbstractMap.SimpleEntry<String, String>("single if a message contains only one document. In this case, a header with the action (write, update or delete) will be added. multiple if a message contains all documents.", this.commitMode));
        properties.put("commit.size", new AbstractMap.SimpleEntry<String, Integer>("Amount of documents to send into each message if the value of commit.mode property is multiple. In single mode this value represents the amount of messages to be sent.", this.commitSize));
        properties.put("headers.static", new AbstractMap.SimpleEntry<String, String>("Headers to add to each message. It must have the form key1=value1,key2=value2.", this.headersStatic));
        properties.put("headers.dynamic", new AbstractMap.SimpleEntry<String, List<String>>("Document's fields to add as headers to each message. It must have the form field1,field2. Only used when the value of commit.mode property is single", this.headersDynamic));
        return properties;
    }

    private void addHeaders(RabbitMQMessage message, RabbitDocument document) {
        message.setHeaders(this.headersStatic);
        for (RabbitDocument.RabbitDocumentField rabbitDocumentField : document.getFields()) {
            if (!this.headersDynamic.contains(rabbitDocumentField.getKey())) continue;
            message.addHeader(rabbitDocumentField.getKey(), rabbitDocumentField.getValues().get(0));
        }
    }
}

