// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

//! Compare opendal with other projects to find out the differences and areas that opendal can improve.
//!
//! All documents listed should be treated as highly biased. Because:
//!
//! - OpenDAL's maintainers and contributors write them.
//! - Writers may not be familiar with the compared projects (at least not as familiar with OpenDAL)
//!
//! Let's see OpenDAL:
//!
//! - [vs `object_store`][`vs_object_store`]

#[doc = include_str!("vs_object_store.md")]
pub mod vs_object_store {}
