/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hbase.thirdparty.com.google.gson.JsonArray;
import org.apache.hbase.thirdparty.com.google.gson.JsonElement;
import org.apache.hbase.thirdparty.com.google.gson.JsonObject;
import org.apache.hbase.thirdparty.com.google.gson.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcedureTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureTestUtil.class);

    private ProcedureTestUtil() {
    }

    private static Optional<JsonObject> getProcedure(HBaseTestingUtility util, Class<? extends Procedure<?>> clazz, JsonParser parser) throws IOException {
        JsonArray array = parser.parse(util.getAdmin().getProcedures()).getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            String className = obj.get("className").getAsString();
            if (!className.equals(clazz.getName())) continue;
            return Optional.of(obj);
        }
        return Optional.empty();
    }

    public static void waitUntilProcedureWaitingTimeout(HBaseTestingUtility util, Class<? extends Procedure<?>> clazz, long timeout) throws IOException {
        JsonParser parser = new JsonParser();
        util.waitFor(timeout, () -> ProcedureTestUtil.getProcedure(util, clazz, parser).filter(o -> ProcedureProtos.ProcedureState.WAITING_TIMEOUT.name().equals(o.get("state").getAsString())).isPresent());
    }

    public static void waitUntilProcedureTimeoutIncrease(HBaseTestingUtility util, Class<? extends Procedure<?>> clazz, int times) throws IOException, InterruptedException {
        JsonParser parser = new JsonParser();
        long oldTimeout = 0L;
        int timeoutIncrements = 0;
        while (true) {
            long timeout;
            if ((timeout = ProcedureTestUtil.getProcedure(util, clazz, parser).filter(o -> o.has("timeout")).map(o -> o.get("timeout").getAsLong()).orElse(-1L).longValue()) > oldTimeout) {
                LOG.info("Timeout incremented, was {}, now is {}, increments={}", new Object[]{timeout, oldTimeout, timeoutIncrements});
                oldTimeout = timeout;
                if (++timeoutIncrements > times) break;
            }
            Thread.sleep(1000L);
        }
    }
}

