/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.master.CachedClusterId;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCachedClusterId {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCachedClusterId.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static String clusterId;
    private static HMaster activeMaster;
    private static HMaster standByMaster;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        activeMaster = TEST_UTIL.getHBaseCluster().getMaster();
        clusterId = activeMaster.getClusterId();
        standByMaster = TEST_UTIL.getHBaseCluster().startMaster().getMaster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testClusterIdMatch() {
        Assert.assertEquals((Object)clusterId, (Object)standByMaster.getClusterId());
    }

    @Test
    public void testMultiThreadedGetClusterId() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        CachedClusterId cachedClusterId = new CachedClusterId((Server)TEST_UTIL.getHBaseCluster().getMaster(), conf);
        MultithreadedTestUtil.TestContext context = new MultithreadedTestUtil.TestContext(conf);
        int numThreads = 16;
        for (int i = 0; i < numThreads; ++i) {
            context.addThread(new GetClusterIdThread(context, cachedClusterId));
        }
        context.startThreads();
        context.stop();
        int cacheMisses = cachedClusterId.getCacheStats();
        Assert.assertEquals((long)cacheMisses, (long)1L);
    }

    private static class GetClusterIdThread
    extends MultithreadedTestUtil.TestThread {
        CachedClusterId cachedClusterId;

        public GetClusterIdThread(MultithreadedTestUtil.TestContext ctx, CachedClusterId clusterId) {
            super(ctx);
            this.cachedClusterId = clusterId;
        }

        @Override
        public void doWork() throws Exception {
            Assert.assertEquals((Object)clusterId, (Object)this.cachedClusterId.getFromCacheOrFetch());
        }
    }
}

