/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestFullLogReconstruction {
    private static final Logger LOG = LoggerFactory.getLogger(TestFullLogReconstruction.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFullLogReconstruction.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"tabletest");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        c.setInt("dfs.heartbeat.interval", 1);
        c.setInt("dfs.client.socket-timeout", 5000);
        c.setInt("hbase.ipc.client.connect.max.retries", 1);
        c.setInt("dfs.client.block.recovery.retries", 1);
        c.setInt("zookeeper.session.timeout", 1000);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testReconstruction() throws Exception {
        Table table = TEST_UTIL.createMultiRegionTable(TABLE_NAME, FAMILY);
        int initialCount = TEST_UTIL.loadTable(table, FAMILY);
        int count = TEST_UTIL.countRows(table);
        Assert.assertEquals((long)initialCount, (long)count);
        for (int i = 0; i < 4; ++i) {
            TEST_UTIL.loadTable(table, FAMILY);
        }
        final JVMClusterUtil.RegionServerThread rsThread = TEST_UTIL.getHBaseCluster().getRegionServerThreads().get(0);
        int index = 0;
        LOG.info("Expiring {}", (Object)TEST_UTIL.getMiniHBaseCluster().getRegionServer(index));
        TEST_UTIL.expireRegionServerSession(index);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !rsThread.isAlive();
            }

            public String explainFailure() throws Exception {
                return rsThread.getRegionServer() + " is still alive";
            }
        });
        LOG.info("Starting count");
        int newCount = TEST_UTIL.countRows(table);
        Assert.assertEquals((long)count, (long)newCount);
        table.close();
    }
}

