/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HealthCheckChore;
import org.apache.hadoop.hbase.HealthChecker;
import org.apache.hadoop.hbase.HealthReport;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestNodeHealthCheckChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNodeHealthCheckChore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestNodeHealthCheckChore.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int SCRIPT_TIMEOUT = 5000;
    private File healthScriptFile;
    private String eol = System.getProperty("line.separator");

    @After
    public void cleanUp() throws IOException {
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = UTIL.getTestFileSystem();
        fs.delete(testDir, true);
        if (!fs.mkdirs(testDir)) {
            throw new IOException("Failed mkdir " + testDir);
        }
    }

    @Test
    public void testHealthCheckerSuccess() throws Exception {
        String normalScript = "echo \"I am all fine\"";
        this.healthCheckerTest(normalScript, HealthChecker.HealthCheckerExitStatus.SUCCESS);
    }

    @Test
    public void testHealthCheckerFail() throws Exception {
        String errorScript = "echo ERROR" + this.eol + "echo \"Node not healthy\"";
        this.healthCheckerTest(errorScript, HealthChecker.HealthCheckerExitStatus.FAILED);
    }

    @Test
    public void testHealthCheckerTimeout() throws Exception {
        String timeOutScript = "sleep 10" + this.eol + "echo \"I am fine\"";
        this.healthCheckerTest(timeOutScript, HealthChecker.HealthCheckerExitStatus.TIMED_OUT);
    }

    public void healthCheckerTest(String script, HealthChecker.HealthCheckerExitStatus expectedStatus) throws Exception {
        Configuration config = this.getConfForNodeHealthScript();
        config.addResource(this.healthScriptFile.getName());
        String location = this.healthScriptFile.getAbsolutePath();
        long timeout = config.getLong("hbase.node.health.script.timeout", 5000L);
        HealthChecker checker = new HealthChecker();
        checker.init(location, timeout);
        this.createScript(script, true);
        HealthReport report = checker.checkHealth();
        Assert.assertEquals((Object)expectedStatus, (Object)report.getStatus());
        LOG.info("Health Status:" + report.getHealthReport());
        this.healthScriptFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRSHealthChore() throws Exception {
        StoppableImplementation stop = new StoppableImplementation();
        Configuration conf = this.getConfForNodeHealthScript();
        String errorScript = "echo ERROR" + this.eol + " echo \"Server not healthy\"";
        this.createScript(errorScript, true);
        HealthCheckChore rsChore = new HealthCheckChore(100, (Stoppable)stop, conf);
        try {
            rsChore.chore();
            rsChore.chore();
            Assert.assertFalse((String)"Stoppable must not be stopped.", (boolean)stop.isStopped());
            rsChore.chore();
            Assert.assertTrue((String)"Stoppable must have been stopped.", (boolean)stop.isStopped());
        }
        finally {
            stop.stop("Finished w/ test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createScript(String scriptStr, boolean setExecutable) throws Exception {
        if (!this.healthScriptFile.exists() && !this.healthScriptFile.createNewFile()) {
            throw new IOException("Failed create of " + this.healthScriptFile);
        }
        try (PrintWriter pw = new PrintWriter(new FileOutputStream(this.healthScriptFile));){
            pw.println(scriptStr);
            pw.flush();
        }
        this.healthScriptFile.setExecutable(setExecutable);
        LOG.info("Created " + this.healthScriptFile + ", executable=" + setExecutable);
    }

    private Configuration getConfForNodeHealthScript() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        File tempDir = new File(UTIL.getDataTestDir().toString());
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new IOException("Failed mkdirs " + tempDir);
        }
        String scriptName = "HealthScript" + UTIL.getRandomUUID().toString() + (Shell.WINDOWS ? ".cmd" : ".sh");
        this.healthScriptFile = new File(tempDir.getAbsolutePath(), scriptName);
        conf.set("hbase.node.health.script.location", this.healthScriptFile.getAbsolutePath());
        conf.setLong("hbase.node.health.failure.threshold", 3L);
        conf.setLong("hbase.node.health.script.timeout", 5000L);
        return conf;
    }

    private static class StoppableImplementation
    implements Stoppable {
        private volatile boolean stop = false;

        private StoppableImplementation() {
        }

        public void stop(String why) {
            this.stop = true;
        }

        public boolean isStopped() {
            return this.stop;
        }
    }
}

