/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncSnapshotAdminApi
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncSnapshotAdminApi.class);
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    String snapshotName1 = "snapshotName1";
    String snapshotName2 = "snapshotName2";
    String snapshotName3 = "snapshotName3";

    @After
    public void cleanup() throws Exception {
        this.admin.deleteSnapshots(MATCH_ALL).get();
        ((List)this.admin.listTableNames().get()).forEach(t -> {
            Void cfr_ignored_0 = (Void)this.admin.disableTable(t).join();
        });
        ((List)this.admin.listTableNames().get()).forEach(t -> {
            Void cfr_ignored_0 = (Void)this.admin.deleteTable(t).join();
        });
    }

    @Test
    public void testTakeSnapshot() throws Exception {
        Admin syncAdmin = TEST_UTIL.getAdmin();
        Table table = TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"f1"));
        for (int i = 0; i < 3000; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"cq"), Bytes.toBytes((int)i)));
        }
        this.admin.snapshot(this.snapshotName1, this.tableName).get();
        this.admin.snapshot(this.snapshotName2, this.tableName).get();
        List snapshots = syncAdmin.listSnapshots();
        Collections.sort(snapshots, (snap1, snap2) -> {
            Assert.assertNotNull((Object)snap1);
            Assert.assertNotNull((Object)snap1.getName());
            Assert.assertNotNull((Object)snap2);
            Assert.assertNotNull((Object)snap2.getName());
            return snap1.getName().compareTo(snap2.getName());
        });
        Assert.assertEquals((Object)this.snapshotName1, (Object)((SnapshotDescription)snapshots.get(0)).getName());
        Assert.assertEquals((Object)this.tableName, (Object)((SnapshotDescription)snapshots.get(0)).getTableName());
        Assert.assertEquals((Object)SnapshotType.FLUSH, (Object)((SnapshotDescription)snapshots.get(0)).getType());
        Assert.assertEquals((Object)this.snapshotName2, (Object)((SnapshotDescription)snapshots.get(1)).getName());
        Assert.assertEquals((Object)this.tableName, (Object)((SnapshotDescription)snapshots.get(1)).getTableName());
        Assert.assertEquals((Object)SnapshotType.FLUSH, (Object)((SnapshotDescription)snapshots.get(1)).getType());
    }

    @Test
    public void testCloneSnapshot() throws Exception {
        TableName tableName2 = TableName.valueOf((String)"testCloneSnapshot2");
        Admin syncAdmin = TEST_UTIL.getAdmin();
        Table table = TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"f1"));
        for (int i = 0; i < 3000; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"cq"), Bytes.toBytes((int)i)));
        }
        this.admin.snapshot(this.snapshotName1, this.tableName).get();
        List snapshots = syncAdmin.listSnapshots();
        Assert.assertEquals((long)1L, (long)snapshots.size());
        Assert.assertEquals((Object)this.snapshotName1, (Object)((SnapshotDescription)snapshots.get(0)).getName());
        Assert.assertEquals((Object)this.tableName, (Object)((SnapshotDescription)snapshots.get(0)).getTableName());
        Assert.assertEquals((Object)SnapshotType.FLUSH, (Object)((SnapshotDescription)snapshots.get(0)).getType());
        boolean failed = false;
        try {
            this.admin.cloneSnapshot(this.snapshotName1, this.tableName).get();
        }
        catch (Exception e) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        Assert.assertTrue((!syncAdmin.tableExists(tableName2) ? 1 : 0) != 0);
        this.admin.cloneSnapshot(this.snapshotName1, tableName2).get();
        syncAdmin.tableExists(tableName2);
    }

    private void assertResult(TableName tableName, int expectedRowCount) throws IOException {
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Scan scan = new Scan();
            try (ResultScanner scanner = table.getScanner(scan);){
                Result result;
                int rowCount = 0;
                while ((result = scanner.next()) != null) {
                    Assert.assertArrayEquals((byte[])result.getRow(), (byte[])Bytes.toBytes((int)rowCount));
                    Assert.assertArrayEquals((byte[])result.getValue(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"cq")), (byte[])Bytes.toBytes((int)rowCount));
                    ++rowCount;
                }
                Assert.assertEquals((long)rowCount, (long)expectedRowCount);
            }
        }
    }

    @Test
    public void testRestoreSnapshot() throws Exception {
        Table table = TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"f1"));
        for (int i = 0; i < 3000; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"cq"), Bytes.toBytes((int)i)));
        }
        Assert.assertEquals((long)0L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.snapshot(this.snapshotName1, this.tableName).get();
        this.admin.snapshot(this.snapshotName2, this.tableName).get();
        Assert.assertEquals((long)2L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.disableTable(this.tableName).get();
        this.admin.restoreSnapshot(this.snapshotName1, true).get();
        this.admin.enableTable(this.tableName).get();
        this.assertResult(this.tableName, 3000);
        this.admin.disableTable(this.tableName).get();
        this.admin.restoreSnapshot(this.snapshotName2, false).get();
        this.admin.enableTable(this.tableName).get();
        this.assertResult(this.tableName, 3000);
    }

    @Test
    public void testListSnapshots() throws Exception {
        Table table = TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"f1"));
        for (int i = 0; i < 3000; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"cq"), Bytes.toBytes((int)i)));
        }
        Assert.assertEquals((long)0L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.snapshot(this.snapshotName1, this.tableName).get();
        this.admin.snapshot(this.snapshotName2, this.tableName).get();
        this.admin.snapshot(this.snapshotName3, this.tableName).get();
        Assert.assertEquals((long)3L, (long)((List)this.admin.listSnapshots().get()).size());
        Assert.assertEquals((long)3L, (long)((List)this.admin.listSnapshots(Pattern.compile("(.*)")).get()).size());
        Assert.assertEquals((long)3L, (long)((List)this.admin.listSnapshots(Pattern.compile("snapshotName(\\d+)")).get()).size());
        Assert.assertEquals((long)2L, (long)((List)this.admin.listSnapshots(Pattern.compile("snapshotName[1|3]")).get()).size());
        Assert.assertEquals((long)3L, (long)((List)this.admin.listSnapshots(Pattern.compile("snapshot(.*)")).get()).size());
        Assert.assertEquals((long)3L, (long)((List)this.admin.listTableSnapshots(Pattern.compile("testListSnapshots"), Pattern.compile("s(.*)")).get()).size());
        Assert.assertEquals((long)0L, (long)((List)this.admin.listTableSnapshots(Pattern.compile("fakeTableName"), Pattern.compile("snap(.*)")).get()).size());
        Assert.assertEquals((long)2L, (long)((List)this.admin.listTableSnapshots(Pattern.compile("test(.*)"), Pattern.compile("snap(.*)[1|3]")).get()).size());
    }

    @Test
    public void testDeleteSnapshots() throws Exception {
        Table table = TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"f1"));
        for (int i = 0; i < 3000; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"cq"), Bytes.toBytes((int)i)));
        }
        Assert.assertEquals((long)0L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.snapshot(this.snapshotName1, this.tableName).get();
        this.admin.snapshot(this.snapshotName2, this.tableName).get();
        this.admin.snapshot(this.snapshotName3, this.tableName).get();
        Assert.assertEquals((long)3L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.deleteSnapshot(this.snapshotName1).get();
        Assert.assertEquals((long)2L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.deleteSnapshots(Pattern.compile("(.*)abc")).get();
        Assert.assertEquals((long)2L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.deleteSnapshots(Pattern.compile("(.*)1")).get();
        Assert.assertEquals((long)2L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.deleteTableSnapshots(Pattern.compile("(.*)"), Pattern.compile("(.*)1")).get();
        Assert.assertEquals((long)2L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.deleteTableSnapshots(Pattern.compile("(.*)"), Pattern.compile("(.*)2")).get();
        Assert.assertEquals((long)1L, (long)((List)this.admin.listSnapshots().get()).size());
        this.admin.deleteTableSnapshots(Pattern.compile("(.*)"), Pattern.compile("(.*)3")).get();
        Assert.assertEquals((long)0L, (long)((List)this.admin.listSnapshots().get()).size());
    }
}

