/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestGetProcedureResult {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGetProcedureResult.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private MasterProtos.GetProcedureResultResponse.State getState(long procId) throws MasterNotRunningException, IOException, ServiceException {
        MasterKeepAliveConnection master = ((ConnectionImplementation)UTIL.getConnection()).getMaster();
        MasterProtos.GetProcedureResultResponse resp = master.getProcedureResult(null, MasterProtos.GetProcedureResultRequest.newBuilder().setProcId(procId).build());
        return resp.getState();
    }

    @Test
    public void testRace() throws Exception {
        ProcedureExecutor executor = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        DummyProcedure p = new DummyProcedure();
        final long procId = executor.submitProcedure((Procedure)p);
        p.failureSet.await();
        Assert.assertEquals((Object)MasterProtos.GetProcedureResultResponse.State.RUNNING, (Object)this.getState(procId));
        p.canRollback.countDown();
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestGetProcedureResult.this.getState(procId) == MasterProtos.GetProcedureResultResponse.State.FINISHED;
            }

            public String explainFailure() throws Exception {
                return "Procedure pid=" + procId + " is still in " + TestGetProcedureResult.this.getState(procId) + " state, expected " + MasterProtos.GetProcedureResultResponse.State.FINISHED;
            }
        });
    }

    public static final class DummyProcedure
    extends Procedure<MasterProcedureEnv>
    implements TableProcedureInterface {
        private final CountDownLatch failureSet = new CountDownLatch(1);
        private final CountDownLatch canRollback = new CountDownLatch(1);

        public TableName getTableName() {
            return TableName.valueOf((String)"dummy");
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.READ;
        }

        protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            this.setFailure("dummy", new IOException("inject error"));
            this.failureSet.countDown();
            return null;
        }

        protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
            this.canRollback.await();
        }

        protected boolean abort(MasterProcedureEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }
    }
}

