/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.MetaWithReplicasTestBase;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestIncreaseMetaReplicaThroughConfig
extends MetaWithReplicasTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIncreaseMetaReplicaThroughConfig.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestIncreaseMetaReplicaThroughConfig.startCluster();
    }

    @Test
    public void testUpgradeAndIncreaseReplicaCount() throws Exception {
        HMaster oldMaster = TEST_UTIL.getMiniHBaseCluster().getMaster();
        TableDescriptors oldTds = oldMaster.getTableDescriptors();
        TableDescriptor oldMetaTd = oldTds.get(TableName.META_TABLE_NAME);
        Assert.assertEquals((long)3L, (long)oldMetaTd.getRegionReplication());
        oldTds.update(TableDescriptorBuilder.newBuilder((TableDescriptor)oldMetaTd).setRegionReplication(1).build());
        oldMaster.stop("Restarting");
        TEST_UTIL.waitFor(30000L, () -> oldMaster.isStopped());
        TEST_UTIL.getMiniHBaseCluster().getConfiguration().setInt("hbase.meta.replica.count", 5);
        TEST_UTIL.getMiniHBaseCluster().startMaster();
        TEST_UTIL.waitFor(30000L, () -> TEST_UTIL.getZooKeeperWatcher().getMetaReplicaNodes().size() == 5);
    }
}

