/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.ZKConnectionRegistry;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ReadOnlyZKClient;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.zookeeper.KeeperException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestZKConnectionRegistry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKConnectionRegistry.class);
    @Rule
    public final TestName name = new TestName();
    static final Logger LOG = LoggerFactory.getLogger(TestZKConnectionRegistry.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ZKConnectionRegistry REGISTRY;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        HBaseTestingUtility.setReplicas(TEST_UTIL.getAdmin(), TableName.META_TABLE_NAME, 3);
        REGISTRY = new ZKConnectionRegistry(TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)REGISTRY, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws InterruptedException, ExecutionException, IOException {
        LOG.info("STARTED TEST");
        String clusterId = (String)REGISTRY.getClusterId().get();
        String expectedClusterId = TEST_UTIL.getHBaseCluster().getMaster().getClusterId();
        Assert.assertEquals((String)("Expected " + expectedClusterId + ", found=" + clusterId), (Object)expectedClusterId, (Object)clusterId);
        Assert.assertEquals((Object)TEST_UTIL.getHBaseCluster().getMaster().getServerName(), REGISTRY.getActiveMaster().get());
        RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(TEST_UTIL, (ConnectionRegistry)REGISTRY);
        RegionLocations locs = (RegionLocations)REGISTRY.getMetaRegionLocations().get();
        Assert.assertEquals((long)3L, (long)locs.getRegionLocations().length);
        IntStream.range(0, 3).forEach(i -> {
            HRegionLocation loc = locs.getRegionLocation(i);
            Assert.assertNotNull((String)("Replica " + i + " doesn't have location"), (Object)loc);
            Assert.assertEquals((Object)TableName.META_TABLE_NAME, (Object)loc.getRegion().getTable());
            Assert.assertEquals((long)i, (long)loc.getRegion().getReplicaId());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndependentZKConnections() throws IOException {
        try (ReadOnlyZKClient zk1 = REGISTRY.getZKClient();){
            Configuration otherConf = new Configuration(TEST_UTIL.getConfiguration());
            otherConf.set("hbase.zookeeper.quorum", MiniZooKeeperCluster.HOST);
            try (ZKConnectionRegistry otherRegistry = new ZKConnectionRegistry(otherConf);){
                ReadOnlyZKClient zk2 = otherRegistry.getZKClient();
                Assert.assertNotSame((String)"Using a different configuration / quorum should result in different backing zk connection.", (Object)zk1, (Object)zk2);
                Assert.assertNotEquals((String)"Using a different configrution / quorum should be reflected in the zk connection.", (Object)zk1.getConnectString(), (Object)zk2.getConnectString());
            }
        }
        finally {
            LOG.info("DONE!");
        }
    }

    @Test
    public void testNoMetaAvailable() throws InterruptedException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("zookeeper.znode.metaserver", "whatever");
        try (ZKConnectionRegistry registry = new ZKConnectionRegistry(conf);){
            try {
                registry.getMetaRegionLocations().get();
                Assert.fail((String)"Should have failed since we set an incorrect meta znode prefix");
            }
            catch (ExecutionException e) {
                MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
            }
        }
    }

    @Test
    public void testDiscontinuousLocations() throws ExecutionException, InterruptedException, IOException, KeeperException, TimeoutException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("zookeeper.znode.parent", "/" + this.name.getMethodName());
        ZooKeeperProtos.MetaRegionServer pbrsr = ZooKeeperProtos.MetaRegionServer.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)ServerName.valueOf((String)"example.org,1,1"))).setRpcVersion(0).setState(RegionState.State.OPEN.convert()).build();
        byte[] data = ProtobufUtil.prependPBMagic((byte[])pbrsr.toByteArray());
        try (ZKWatcher zkw = new ZKWatcher(conf, this.name.getMethodName(), new Abortable(){

            public void abort(String why, Throwable e) {
            }

            public boolean isAborted() {
                return false;
            }
        });){
            ZKUtil.createSetData((ZKWatcher)zkw, (String)zkw.getZNodePaths().getZNodeForReplica(0), (byte[])data);
            ZKUtil.createSetData((ZKWatcher)zkw, (String)zkw.getZNodePaths().getZNodeForReplica(3), (byte[])data);
            List znodes = zkw.getMetaReplicaNodes();
            Assert.assertEquals((long)2L, (long)znodes.size());
            try (ZKConnectionRegistry registry = new ZKConnectionRegistry(conf);){
                CompletableFuture cf = registry.getMetaRegionLocations();
                RegionLocations locations = (RegionLocations)cf.get(60L, TimeUnit.SECONDS);
                Assert.assertEquals((long)2L, (long)locations.numNonNullElements());
            }
        }
    }
}

