/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.hamcrest;

import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.Is;

public final class BytesMatchers {
    private BytesMatchers() {
    }

    public static Matcher<byte[]> bytesAsStringBinary(String binary) {
        return BytesMatchers.bytesAsStringBinary((Matcher<String>)Is.is((Object)binary));
    }

    public static Matcher<byte[]> bytesAsStringBinary(final Matcher<String> matcher) {
        return new TypeSafeDiagnosingMatcher<byte[]>(){

            protected boolean matchesSafely(byte[] item, Description mismatchDescription) {
                String binary = Bytes.toStringBinary((byte[])item);
                if (matcher.matches((Object)binary)) {
                    return true;
                }
                mismatchDescription.appendText("was a byte[] with a Bytes.toStringBinary value ");
                matcher.describeMismatch((Object)binary, mismatchDescription);
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("has a byte[] with a Bytes.toStringBinary value that ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }
}

