/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ThrottleQuotaTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ThrottleQuotaTestUtil.class);
    private static ManualEnvironmentEdge envEdge = new ManualEnvironmentEdge();
    private static final int REFRESH_TIME = 1800000;

    private ThrottleQuotaTestUtil() {
        LOG.debug("Call constructor of ThrottleQuotaTestUtil");
    }

    static int doPuts(int maxOps, byte[] family, byte[] qualifier, Table ... tables) {
        return ThrottleQuotaTestUtil.doPuts(maxOps, -1, family, qualifier, tables);
    }

    static int doPuts(int maxOps, int valueSize, byte[] family, byte[] qualifier, Table ... tables) {
        int count;
        try {
            for (count = 0; count < maxOps; count += tables.length) {
                Put put = new Put(Bytes.toBytes((String)("row-" + count)));
                byte[] value = valueSize < 0 ? Bytes.toBytes((String)("data-" + count)) : ThrottleQuotaTestUtil.generateValue(valueSize);
                put.addColumn(family, qualifier, value);
                for (Table table : tables) {
                    table.put(put);
                }
            }
        }
        catch (IOException e) {
            LOG.error("put failed after nRetries=" + count, (Throwable)e);
        }
        return count;
    }

    private static byte[] generateValue(int valueSize) {
        byte[] bytes = new byte[valueSize];
        for (int i = 0; i < valueSize; ++i) {
            bytes[i] = 97;
        }
        return bytes;
    }

    static long doGets(int maxOps, Table ... tables) {
        int count;
        try {
            for (count = 0; count < maxOps; count += tables.length) {
                Get get = new Get(Bytes.toBytes((String)("row-" + count)));
                for (Table table : tables) {
                    table.get(get);
                }
            }
        }
        catch (IOException e) {
            LOG.error("get failed after nRetries=" + count, (Throwable)e);
        }
        return count;
    }

    static void triggerUserCacheRefresh(HBaseTestingUtility testUtil, boolean bypass, TableName ... tables) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, bypass, true, false, false, false, false, tables);
    }

    static void triggerTableCacheRefresh(HBaseTestingUtility testUtil, boolean bypass, TableName ... tables) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, bypass, false, true, false, false, false, tables);
    }

    static void triggerNamespaceCacheRefresh(HBaseTestingUtility testUtil, boolean bypass, TableName ... tables) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, bypass, false, false, true, false, false, tables);
    }

    static void triggerRegionServerCacheRefresh(HBaseTestingUtility testUtil, boolean bypass) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, bypass, false, false, false, true, false, new TableName[0]);
    }

    static void triggerExceedThrottleQuotaCacheRefresh(HBaseTestingUtility testUtil, boolean exceedEnabled) throws Exception {
        ThrottleQuotaTestUtil.triggerCacheRefresh(testUtil, exceedEnabled, false, false, false, false, true, new TableName[0]);
    }

    private static void triggerCacheRefresh(HBaseTestingUtility testUtil, boolean bypass, boolean userLimiter, boolean tableLimiter, boolean nsLimiter, boolean rsLimiter, boolean exceedThrottleQuota, TableName ... tables) throws Exception {
        envEdge.incValue(3600000L);
        for (JVMClusterUtil.RegionServerThread rst : testUtil.getMiniHBaseCluster().getRegionServerThreads()) {
            RegionServerRpcQuotaManager quotaManager = rst.getRegionServer().getRegionServerRpcQuotaManager();
            QuotaCache quotaCache = quotaManager.getQuotaCache();
            quotaCache.triggerCacheRefresh();
            Thread.sleep(250L);
            for (TableName table : tables) {
                quotaCache.getTableLimiter(table);
            }
            boolean isUpdated = false;
            while (!isUpdated) {
                boolean rsIsBypass;
                quotaCache.triggerCacheRefresh();
                isUpdated = true;
                for (TableName table : tables) {
                    boolean isBypass = true;
                    if (userLimiter) {
                        isBypass = quotaCache.getUserLimiter(User.getCurrent().getUGI(), table).isBypass();
                    }
                    if (tableLimiter) {
                        isBypass &= quotaCache.getTableLimiter(table).isBypass();
                    }
                    if (nsLimiter) {
                        isBypass &= quotaCache.getNamespaceLimiter(table.getNamespaceAsString()).isBypass();
                    }
                    if (isBypass == bypass) continue;
                    envEdge.incValue(100L);
                    isUpdated = false;
                    break;
                }
                if (rsLimiter && (rsIsBypass = quotaCache.getRegionServerQuotaLimiter("all").isBypass()) != bypass) {
                    envEdge.incValue(100L);
                    isUpdated = false;
                }
                if (!exceedThrottleQuota || quotaCache.isExceedThrottleQuotaEnabled() == bypass) continue;
                envEdge.incValue(100L);
                isUpdated = false;
            }
            LOG.debug("QuotaCache");
            LOG.debug(Objects.toString(quotaCache.getNamespaceQuotaCache()));
            LOG.debug(Objects.toString(quotaCache.getTableQuotaCache()));
            LOG.debug(Objects.toString(quotaCache.getUserQuotaCache()));
            LOG.debug(Objects.toString(quotaCache.getRegionServerQuotaCache()));
        }
    }

    static void waitMinuteQuota() {
        envEdge.incValue(70000L);
    }

    static void clearQuotaCache(HBaseTestingUtility testUtil) {
        for (JVMClusterUtil.RegionServerThread rst : testUtil.getMiniHBaseCluster().getRegionServerThreads()) {
            RegionServerRpcQuotaManager quotaManager = rst.getRegionServer().getRegionServerRpcQuotaManager();
            QuotaCache quotaCache = quotaManager.getQuotaCache();
            quotaCache.getNamespaceQuotaCache().clear();
            quotaCache.getTableQuotaCache().clear();
            quotaCache.getUserQuotaCache().clear();
            quotaCache.getRegionServerQuotaCache().clear();
        }
    }

    static {
        envEdge.setValue(EnvironmentEdgeManager.currentTime());
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)envEdge);
    }
}

