/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.AbstractTestDateTieredCompactionPolicy;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestDateTieredCompactionPolicyOverflow
extends AbstractTestDateTieredCompactionPolicy {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDateTieredCompactionPolicyOverflow.class);

    @Override
    protected void config() {
        super.config();
        this.conf.set("hbase.hstore.engine.class", "org.apache.hadoop.hbase.regionserver.DateTieredStoreEngine");
        this.conf.setLong("hbase.hstore.compaction.date.tiered.max.storefile.age.millis", 100L);
        this.conf.setLong("hbase.hstore.compaction.date.tiered.incoming.window.min", 3L);
        this.conf.setLong("hbase.hstore.compaction.date.tiered.base.window.millis", 0x3FFFFFFFFFFFFFFFL);
        this.conf.setInt("hbase.hstore.compaction.date.tiered.windows.per.tier", 2);
        this.conf.setBoolean("hbase.hstore.compaction.date.tiered.single.output.for.minor.compaction", false);
        this.conf.setInt("hbase.hstore.compaction.min", 2);
        this.conf.setInt("hbase.hstore.compaction.max", 12);
        this.conf.setFloat("hbase.hstore.compaction.ratio", 1.2f);
        this.conf.setInt("hbase.hstore.blockingStoreFiles", 20);
        this.conf.setLong("hbase.hregion.majorcompaction", 10L);
    }

    @Test
    public void maxValuesForMajor() throws IOException {
        long[] minTimestamps = new long[]{Long.MIN_VALUE, -100L};
        long[] maxTimestamps = new long[]{-8L, Long.MAX_VALUE};
        long[] sizes = new long[]{0L, 1L};
        this.compactEquals(Long.MAX_VALUE, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{0L, 1L}, new long[]{Long.MIN_VALUE, -4611686018427387903L, 0L, 0x3FFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFEL}, true, true);
    }
}

