/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAsTable;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestScanner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScanner.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestScanner.class);
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static final byte[] FIRST_ROW = HConstants.EMPTY_START_ROW;
    private static final byte[][] COLS = new byte[][]{HConstants.CATALOG_FAMILY};
    private static final byte[][] EXPLICIT_COLS = new byte[][]{HConstants.REGIONINFO_QUALIFIER, HConstants.SERVER_QUALIFIER};
    static final HTableDescriptor TESTTABLEDESC = new HTableDescriptor(TableName.valueOf((String)"testscanner"));
    public static final HRegionInfo REGION_INFO;
    private static final byte[] ROW_KEY;
    private static final long START_CODE = Long.MAX_VALUE;
    private HRegion region;
    private byte[] firstRowBytes = HBaseTestingUtility.START_KEY_BYTES;
    private byte[] secondRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
    private byte[] thirdRowBytes;
    private final byte[] col1;

    public TestScanner() {
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.secondRowBytes[n] = (byte)(this.secondRowBytes[n] + 1);
        this.thirdRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        this.thirdRowBytes[HBaseTestingUtility.START_KEY_BYTES.length - 1] = (byte)(this.thirdRowBytes[HBaseTestingUtility.START_KEY_BYTES.length - 1] + 2);
        this.col1 = Bytes.toBytes((String)"column1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopRow() throws Exception {
        byte[] startrow = Bytes.toBytes((String)"bbb");
        byte[] stoprow = Bytes.toBytes((String)"ccc");
        try {
            this.region = TEST_UTIL.createLocalHRegion((TableDescriptor)TESTTABLEDESC, null, null);
            HBaseTestCase.addContent((Region)this.region, HConstants.CATALOG_FAMILY);
            ArrayList results = new ArrayList();
            Scan scan = new Scan(Bytes.toBytes((String)"abc"), Bytes.toBytes((String)"abd"));
            scan.addFamily(HConstants.CATALOG_FAMILY);
            HRegion.RegionScannerImpl s = this.region.getScanner(scan);
            int count = 0;
            while (s.next(results)) {
                ++count;
            }
            s.close();
            Assert.assertEquals((long)0L, (long)count);
            scan = new Scan(startrow, stoprow);
            scan.addFamily(HConstants.CATALOG_FAMILY);
            s = this.region.getScanner(scan);
            count = 0;
            Cell kv = null;
            results = new ArrayList();
            boolean first = true;
            while (s.next(results)) {
                kv = (Cell)results.get(0);
                if (first) {
                    Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)kv, (byte[])startrow));
                    first = false;
                }
                ++count;
            }
            Assert.assertTrue((Bytes.BYTES_COMPARATOR.compare(stoprow, CellUtil.cloneRow(kv)) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((count > 10 ? 1 : 0) != 0);
            s.close();
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
        }
    }

    void rowPrefixFilter(Scan scan) throws IOException {
        ArrayList results = new ArrayList();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        HRegion.RegionScannerImpl s = this.region.getScanner(scan);
        boolean hasMore = true;
        while (hasMore) {
            hasMore = s.next(results);
            for (Cell kv : results) {
                Assert.assertEquals((long)97L, (long)CellUtil.cloneRow((Cell)kv)[0]);
                Assert.assertEquals((long)98L, (long)CellUtil.cloneRow((Cell)kv)[1]);
            }
            results.clear();
        }
        s.close();
    }

    void rowInclusiveStopFilter(Scan scan, byte[] stopRow) throws IOException {
        ArrayList results = new ArrayList();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        HRegion.RegionScannerImpl s = this.region.getScanner(scan);
        boolean hasMore = true;
        while (hasMore) {
            hasMore = s.next(results);
            for (Cell kv : results) {
                Assert.assertTrue((Bytes.compareTo((byte[])CellUtil.cloneRow((Cell)kv), (byte[])stopRow) <= 0 ? 1 : 0) != 0);
            }
            results.clear();
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilters() throws IOException {
        try {
            this.region = TEST_UTIL.createLocalHRegion((TableDescriptor)TESTTABLEDESC, null, null);
            HBaseTestCase.addContent((Region)this.region, HConstants.CATALOG_FAMILY);
            byte[] prefix = Bytes.toBytes((String)"ab");
            PrefixFilter newFilter = new PrefixFilter(prefix);
            Scan scan = new Scan();
            scan.setFilter((Filter)newFilter);
            this.rowPrefixFilter(scan);
            byte[] stopRow = Bytes.toBytes((String)"bbc");
            newFilter = new WhileMatchFilter((Filter)new InclusiveStopFilter(stopRow));
            scan = new Scan();
            scan.setFilter((Filter)newFilter);
            this.rowInclusiveStopFilter(scan, stopRow);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRaceBetweenClientAndTimeout() throws Exception {
        try {
            this.region = TEST_UTIL.createLocalHRegion((TableDescriptor)TESTTABLEDESC, null, null);
            HBaseTestCase.addContent((Region)this.region, HConstants.CATALOG_FAMILY);
            Scan scan = new Scan();
            HRegion.RegionScannerImpl s = this.region.getScanner(scan);
            ArrayList results = new ArrayList();
            try {
                s.next(results);
                s.close();
                s.next(results);
                Assert.fail((String)"We don't want anything more, we should be failing");
            }
            catch (UnknownScannerException ex) {
                HBaseTestingUtility.closeRegionAndWAL(this.region);
                return;
            }
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanner() throws IOException {
        try {
            this.region = TEST_UTIL.createLocalHRegion((TableDescriptor)TESTTABLEDESC, null, null);
            RegionAsTable table = new RegionAsTable((Region)this.region);
            Put put = new Put(ROW_KEY, System.currentTimeMillis());
            put.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, REGION_INFO.toByteArray());
            table.put(put);
            this.scan(false, null);
            this.getRegionInfo(table);
            this.region.close();
            this.region = HRegion.openHRegion((HRegion)this.region, null);
            table = new RegionAsTable((Region)this.region);
            this.scan(false, null);
            this.getRegionInfo(table);
            String address = "127.0.0.1:" + HBaseTestingUtility.randomFreePort();
            put = new Put(ROW_KEY, System.currentTimeMillis());
            put.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)address));
            table.put(put);
            this.scan(true, address.toString());
            this.getRegionInfo(table);
            this.region.flush(true);
            this.scan(true, address.toString());
            this.getRegionInfo(table);
            this.region.close();
            this.region = HRegion.openHRegion((HRegion)this.region, null);
            table = new RegionAsTable((Region)this.region);
            this.scan(true, address.toString());
            this.getRegionInfo(table);
            address = "bar.foo.com:4321";
            put = new Put(ROW_KEY, System.currentTimeMillis());
            put.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)address));
            table.put(put);
            this.scan(true, address.toString());
            this.getRegionInfo(table);
            this.region.flush(true);
            this.scan(true, address.toString());
            this.getRegionInfo(table);
            this.region.close();
            this.region = HRegion.openHRegion((HRegion)this.region, null);
            table = new RegionAsTable((Region)this.region);
            this.scan(true, address.toString());
            this.getRegionInfo(table);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
        }
    }

    private void validateRegionInfo(byte[] regionBytes) throws IOException {
        HRegionInfo info = HRegionInfo.parseFromOrNull((byte[])regionBytes);
        Assert.assertEquals((long)REGION_INFO.getRegionId(), (long)info.getRegionId());
        Assert.assertEquals((long)0L, (long)info.getStartKey().length);
        Assert.assertEquals((long)0L, (long)info.getEndKey().length);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])info.getRegionName(), (byte[])REGION_INFO.getRegionName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(boolean validateStartcode, String serverName) throws IOException {
        HRegion.RegionScannerImpl scanner = null;
        Scan scan = null;
        ArrayList<Cell> results = new ArrayList<Cell>();
        byte[][][] scanColumns = new byte[][][]{COLS, EXPLICIT_COLS};
        for (int i = 0; i < scanColumns.length; ++i) {
            try {
                scan = new Scan(FIRST_ROW);
                for (int ii = 0; ii < EXPLICIT_COLS.length; ++ii) {
                    scan.addColumn(COLS[0], EXPLICIT_COLS[ii]);
                }
                scanner = this.region.getScanner(scan);
                while (scanner.next(results)) {
                    Assert.assertTrue((boolean)this.hasColumn(results, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                    byte[] val = CellUtil.cloneValue((Cell)this.getColumn(results, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                    this.validateRegionInfo(val);
                    if (validateStartcode) {
                        Assert.assertNotNull((Object)val);
                        Assert.assertFalse((val.length == 0 ? 1 : 0) != 0);
                        long startCode = Bytes.toLong((byte[])val);
                        Assert.assertEquals((long)Long.MAX_VALUE, (long)startCode);
                    }
                    if (serverName == null) continue;
                    Assert.assertTrue((boolean)this.hasColumn(results, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
                    val = CellUtil.cloneValue((Cell)this.getColumn(results, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
                    Assert.assertNotNull((Object)val);
                    Assert.assertFalse((val.length == 0 ? 1 : 0) != 0);
                    String server = Bytes.toString((byte[])val);
                    Assert.assertEquals((long)0L, (long)server.compareTo(serverName));
                }
                continue;
            }
            finally {
                HRegion.RegionScannerImpl s = scanner;
                scanner = null;
                if (s != null) {
                    s.close();
                }
            }
        }
    }

    private boolean hasColumn(List<Cell> kvs, byte[] family, byte[] qualifier) {
        for (Cell kv : kvs) {
            if (!CellUtil.matchingFamily((Cell)kv, (byte[])family) || !CellUtil.matchingQualifier((Cell)kv, (byte[])qualifier)) continue;
            return true;
        }
        return false;
    }

    private Cell getColumn(List<Cell> kvs, byte[] family, byte[] qualifier) {
        for (Cell kv : kvs) {
            if (!CellUtil.matchingFamily((Cell)kv, (byte[])family) || !CellUtil.matchingQualifier((Cell)kv, (byte[])qualifier)) continue;
            return kv;
        }
        return null;
    }

    private void getRegionInfo(Table table) throws IOException {
        Get get = new Get(ROW_KEY);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        Result result = table.get(get);
        byte[] bytes = result.value();
        this.validateRegionInfo(bytes);
    }

    @Test
    public void testScanAndSyncFlush() throws Exception {
        this.region = TEST_UTIL.createLocalHRegion((TableDescriptor)TESTTABLEDESC, null, null);
        RegionAsTable hri = new RegionAsTable((Region)this.region);
        try {
            LOG.info("Added: " + HBaseTestCase.addContent(hri, Bytes.toString((byte[])HConstants.CATALOG_FAMILY), Bytes.toString((byte[])HConstants.REGIONINFO_QUALIFIER)));
            int count = this.count(hri, -1, false);
            Assert.assertEquals((long)count, (long)this.count(hri, 100, false));
        }
        catch (Exception e) {
            LOG.error("Failed", (Throwable)e);
            throw e;
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
        }
    }

    @Test
    public void testScanAndRealConcurrentFlush() throws Exception {
        this.region = TEST_UTIL.createLocalHRegion((TableDescriptor)TESTTABLEDESC, null, null);
        RegionAsTable hri = new RegionAsTable((Region)this.region);
        try {
            LOG.info("Added: " + HBaseTestCase.addContent(hri, Bytes.toString((byte[])HConstants.CATALOG_FAMILY), Bytes.toString((byte[])HConstants.REGIONINFO_QUALIFIER)));
            int count = this.count(hri, -1, false);
            Assert.assertEquals((long)count, (long)this.count(hri, 100, true));
        }
        catch (Exception e) {
            LOG.error("Failed", (Throwable)e);
            throw e;
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanAndConcurrentMajorCompact() throws Exception {
        HTableDescriptor htd = TEST_UTIL.createTableDescriptor(this.name.getMethodName());
        this.region = TEST_UTIL.createLocalHRegion((TableDescriptor)htd, null, null);
        RegionAsTable hri = new RegionAsTable((Region)this.region);
        try {
            HBaseTestCase.addContent(hri, Bytes.toString((byte[])HBaseTestingUtility.fam1), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.secondRowBytes);
            HBaseTestCase.addContent(hri, Bytes.toString((byte[])HBaseTestingUtility.fam2), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.secondRowBytes);
            Delete dc = new Delete(this.firstRowBytes);
            dc.addColumns(HBaseTestingUtility.fam1, this.col1);
            this.region.delete(dc);
            this.region.flush(true);
            HBaseTestCase.addContent(hri, Bytes.toString((byte[])HBaseTestingUtility.fam1), Bytes.toString((byte[])this.col1), this.secondRowBytes, this.thirdRowBytes);
            HBaseTestCase.addContent(hri, Bytes.toString((byte[])HBaseTestingUtility.fam2), Bytes.toString((byte[])this.col1), this.secondRowBytes, this.thirdRowBytes);
            this.region.flush(true);
            HRegion.RegionScannerImpl s = this.region.getScanner(new Scan());
            this.region.compact(true);
            ArrayList results = new ArrayList();
            s.next(results);
            Assert.assertTrue((String)("result is not correct, keyValues : " + results), (results.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])this.firstRowBytes));
            Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)((Cell)results.get(0)), (byte[])HBaseTestingUtility.fam2));
            results = new ArrayList();
            s.next(results);
            Assert.assertTrue((results.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])this.secondRowBytes));
            Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)((Cell)results.get(0)), (byte[])HBaseTestingUtility.fam1));
            Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)((Cell)results.get(1)), (byte[])HBaseTestingUtility.fam2));
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
        }
    }

    private int count(Table countTable, int flushIndex, boolean concurrent) throws IOException {
        LOG.info("Taking out counting scan");
        Scan scan = new Scan();
        for (byte[] qualifier : EXPLICIT_COLS) {
            scan.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        }
        ResultScanner s = countTable.getScanner(scan);
        int count = 0;
        boolean justFlushed = false;
        while (s.next() != null) {
            if (justFlushed) {
                LOG.info("after next() just after next flush");
                justFlushed = false;
            }
            if (flushIndex != ++count) continue;
            LOG.info("Starting flush at flush index " + flushIndex);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        TestScanner.this.region.flush(true);
                        LOG.info("Finishing flush");
                    }
                    catch (IOException e) {
                        LOG.info("Failed flush cache");
                    }
                }
            };
            if (concurrent) {
                t.start();
            } else {
                t.run();
            }
            LOG.info("Continuing on after kicking off background flush");
            justFlushed = true;
        }
        s.close();
        LOG.info("Found " + count + " items");
        return count;
    }

    static {
        TESTTABLEDESC.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY).setMaxVersions(10).setBlockCacheEnabled(false).setBlocksize(8192));
        REGION_INFO = new HRegionInfo(TESTTABLEDESC.getTableName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
        ROW_KEY = REGION_INFO.getRegionName();
    }
}

