/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, LargeTests.class})
public class TestHBaseWalOnEC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseWalOnEC.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Parameterized.Parameter
    public String walProvider;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        try {
            MiniDFSCluster cluster = UTIL.startMiniDFSCluster(3);
            DistributedFileSystem fs = cluster.getFileSystem();
            Method enableAllECPolicies = DFSTestUtil.class.getMethod("enableAllECPolicies", DistributedFileSystem.class);
            enableAllECPolicies.invoke(null, fs);
            DFSClient client = fs.getClient();
            Method setErasureCodingPolicy = DFSClient.class.getMethod("setErasureCodingPolicy", String.class, String.class);
            setErasureCodingPolicy.invoke((Object)client, "/", "RS-3-2-1024k");
            try (FSDataOutputStream out = fs.create(new Path("/canary"));){
                Assert.assertFalse((String)"Did not enable EC!", (boolean)out.hasCapability("hflush"));
            }
        }
        catch (NoSuchMethodException e) {
            Assume.assumeNoException((String)"Using an older version of hadoop; EC not available.", (Throwable)e);
        }
        UTIL.getConfiguration().setBoolean("hbase.unsafe.stream.capability.enforce", true);
    }

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({"asyncfs"}, {"filesystem"});
    }

    @Before
    public void setUp() throws Exception {
        UTIL.getConfiguration().set("hbase.wal.provider", this.walProvider);
        UTIL.startMiniCluster(3);
    }

    @After
    public void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testReadWrite() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] cf = Bytes.toBytes((String)"cf");
        byte[] cq = Bytes.toBytes((String)"cq");
        byte[] value = Bytes.toBytes((String)"value");
        TableName name = TableName.valueOf((String)this.getClass().getSimpleName());
        Table t = UTIL.createTable(name, cf);
        t.put(new Put(row).addColumn(cf, cq, value));
        UTIL.getAdmin().flush(name);
        Assert.assertArrayEquals((byte[])value, (byte[])t.get(new Get(row)).getValue(cf, cq));
    }
}

