/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestRefreshRecoveredReplication
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRefreshRecoveredReplication.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRefreshRecoveredReplication.class);
    private static final int BATCH = 50;
    @Rule
    public TestName name = new TestName();
    private TableName tablename;
    private Table table1;
    private Table table2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        NUM_SLAVES1 = 2;
        Configuration conf1 = UTIL1.getConfiguration();
        conf1.setInt("replication.total.buffer.quota", 100);
        TestReplicationBase.setUpBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestReplicationBase.tearDownAfterClass();
    }

    @Before
    public void setup() throws Exception {
        this.setUpBase();
        this.tablename = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)this.tablename).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setScope(1).build()).build();
        UTIL1.getAdmin().createTable(table);
        UTIL2.getAdmin().createTable(table);
        UTIL1.waitTableAvailable(this.tablename);
        UTIL2.waitTableAvailable(this.tablename);
        this.table1 = UTIL1.getConnection().getTable(this.tablename);
        this.table2 = UTIL2.getConnection().getTable(this.tablename);
    }

    @After
    public void teardown() throws Exception {
        this.tearDownBase();
        UTIL1.deleteTableIfAny(this.tablename);
        UTIL2.deleteTableIfAny(this.tablename);
    }

    @Test
    public void testReplicationRefreshSource() throws Exception {
        for (int i = 0; i < 50; ++i) {
            byte[] r = Bytes.toBytes((int)i);
            this.table1.put(new Put(r).addColumn(famName, famName, r));
        }
        List<JVMClusterUtil.RegionServerThread> rss = UTIL1.getMiniHBaseCluster().getLiveRegionServerThreads();
        Assert.assertEquals((long)2L, (long)rss.size());
        Optional<JVMClusterUtil.RegionServerThread> server = rss.stream().filter(rst -> CollectionUtils.isNotEmpty((Collection)rst.getRegionServer().getRegions(this.tablename))).findAny();
        Assert.assertTrue((boolean)server.isPresent());
        HRegionServer otherServer = rss.get(0).getRegionServer() == server.get().getRegionServer() ? rss.get(1).getRegionServer() : rss.get(0).getRegionServer();
        server.get().getRegionServer().abort("stopping for test");
        Replication replication = (Replication)otherServer.getReplicationSourceService();
        UTIL1.waitFor(60000L, () -> !replication.getReplicationManager().getOldSources().isEmpty());
        UTIL1.waitFor(60000L, () -> UTIL1.getMiniHBaseCluster().getLiveRegionServerThreads().size() == NUM_SLAVES1 - 1);
        UTIL1.waitTableAvailable(this.tablename);
        LOG.info("Available {}", (Object)this.tablename);
        hbaseAdmin.disableReplicationPeer("2");
        LOG.info("has replicated {} rows before disable peer", (Object)this.checkReplicationData());
        hbaseAdmin.enableReplicationPeer("2");
        UTIL2.waitFor(60000L, () -> {
            int count = this.checkReplicationData();
            LOG.info("Waiting all logs pushed to slave. Expected {} , actual {}", (Object)50, (Object)count);
            return count == 50;
        });
    }

    private int checkReplicationData() throws IOException {
        int count = 0;
        ResultScanner results = this.table2.getScanner(new Scan().setCaching(50));
        for (Result r : results) {
            ++count;
        }
        return count;
    }
}

