/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.TestSecurityManager;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SystemExitRule
implements TestRule {
    static final SecurityManager securityManager = new TestSecurityManager();

    public Statement apply(final Statement s, Description d) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    SystemExitRule.forbidSystemExitCall();
                    s.evaluate();
                }
                finally {
                    System.setSecurityManager(null);
                }
            }
        };
    }

    private static void forbidSystemExitCall() {
        System.setSecurityManager(securityManager);
    }

    public static class SystemExitInTestException
    extends SecurityException {
    }
}

