/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.logging;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.logging.Log4jUtils;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestLog4jUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLog4jUtils.class);

    @Test
    public void test() {
        Logger zk = LogManager.getLogger((String)"org.apache.zookeeper");
        Level zkLevel = zk.getEffectiveLevel();
        Logger hbaseZk = LogManager.getLogger((String)"org.apache.hadoop.hbase.zookeeper");
        Level hbaseZkLevel = hbaseZk.getEffectiveLevel();
        Logger client = LogManager.getLogger((String)"org.apache.hadoop.hbase.client");
        Level clientLevel = client.getEffectiveLevel();
        Log4jUtils.disableZkAndClientLoggers();
        Assert.assertEquals((Object)Level.OFF, (Object)zk.getLevel());
        Assert.assertEquals((Object)Level.OFF.toString(), (Object)Log4jUtils.getEffectiveLevel((String)zk.getName()));
        Assert.assertEquals((Object)Level.OFF, (Object)hbaseZk.getLevel());
        Assert.assertEquals((Object)Level.OFF.toString(), (Object)Log4jUtils.getEffectiveLevel((String)hbaseZk.getName()));
        Assert.assertEquals((Object)Level.OFF, (Object)client.getLevel());
        Assert.assertEquals((Object)Level.OFF.toString(), (Object)Log4jUtils.getEffectiveLevel((String)client.getName()));
        zk.setLevel(zkLevel);
        hbaseZk.setLevel(hbaseZkLevel);
        client.setLevel(clientLevel);
    }

    @Test
    public void testGetLogFiles() throws IOException {
        Assert.assertTrue((boolean)Log4jUtils.getActiveLogFiles().isEmpty());
    }
}

