/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.List;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.util.Generic;

public class PyCompoundCallable
extends PyObject
implements Traverseproc {
    private List<PyObject> callables = Generic.list();
    private PySystemState systemState = Py.getSystemState();

    public void append(PyObject callable) {
        this.callables.add(callable);
    }

    public void clear() {
        this.callables.clear();
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        Py.setSystemState(this.systemState);
        for (PyObject callable : this.callables) {
            callable.__call__(args, keywords);
        }
        return Py.None;
    }

    @Override
    public String toString() {
        return "<CompoundCallable with " + this.callables.size() + " callables>";
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retValue;
        if (this.systemState != null && (retValue = visit.visit(this.systemState, arg)) != 0) {
            return retValue;
        }
        if (this.callables != null) {
            for (PyObject ob : this.callables) {
                retValue = visit.visit(ob, arg);
                if (retValue == 0) continue;
                return retValue;
            }
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.systemState || this.callables.contains(ob));
    }
}

