/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.buffer;

import org.python.core.BufferProtocol;
import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.buffer.SimpleBuffer;
import org.python.core.buffer.Strided1DWritableBuffer;
import org.python.core.buffer.ZeroByteBuffer;

public class SimpleWritableBuffer
extends SimpleBuffer {
    public SimpleWritableBuffer(int flags, BufferProtocol obj, byte[] storage, int index0, int size) throws PyException, NullPointerException {
        super(obj, storage, index0, size);
        this.addFeatureFlags(1);
        this.checkRequestFlags(flags);
    }

    public SimpleWritableBuffer(int flags, BufferProtocol obj, byte[] storage) throws PyException, NullPointerException {
        this(flags, obj, storage, 0, storage.length);
    }

    @Override
    public final boolean isReadonly() {
        return false;
    }

    @Override
    protected final void checkWritable() {
    }

    @Override
    protected void storeAtImpl(byte value, int byteIndex) {
        this.storage[byteIndex] = value;
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2) {
        if (count2 > 0) {
            int compIndex0 = this.index0 + start;
            return new SimpleView(this.getRoot(), flags, this.storage, compIndex0, count2);
        }
        return new ZeroByteBuffer.View(this.getRoot(), flags);
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int count2, int stride) {
        if (stride == 1 || count2 < 2) {
            return this.getBufferSlice(flags, start, count2);
        }
        int compIndex0 = this.index0 + start;
        return new Strided1DWritableBuffer.SlicedView(this.getRoot(), flags, this.storage, compIndex0, count2, stride);
    }

    static class SimpleView
    extends SimpleWritableBuffer {
        PyBuffer root;

        public SimpleView(PyBuffer root, int flags, byte[] storage, int index0, int size) {
            super(flags, root.getObj(), storage, index0, size);
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }
    }
}

