/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number.formatters;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.StandardPlural;
import org.python.icu.impl.UResource;
import org.python.icu.impl.number.Format;
import org.python.icu.impl.number.FormatQuantity;
import org.python.icu.impl.number.Modifier;
import org.python.icu.impl.number.ModifierHolder;
import org.python.icu.impl.number.PNAffixGenerator;
import org.python.icu.impl.number.PatternString;
import org.python.icu.impl.number.Properties;
import org.python.icu.impl.number.Rounder;
import org.python.icu.impl.number.formatters.CurrencyFormat;
import org.python.icu.impl.number.formatters.RoundingFormat;
import org.python.icu.impl.number.modifiers.ConstantAffixModifier;
import org.python.icu.impl.number.modifiers.PositiveNegativeAffixModifier;
import org.python.icu.impl.number.rounders.SignificantDigitsRounder;
import org.python.icu.text.CompactDecimalFormat;
import org.python.icu.text.DecimalFormat;
import org.python.icu.text.DecimalFormatSymbols;
import org.python.icu.text.NumberFormat;
import org.python.icu.text.NumberingSystem;
import org.python.icu.text.PluralRules;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public class CompactDecimalFormat
extends Format.BeforeFormat {
    static final int MAX_DIGITS = 15;
    private final CompactDecimalData data;
    private final Rounder rounder;
    private final Modifier.PositiveNegativeModifier defaultMod;
    private final CompactDecimalFormat.CompactStyle style;
    private static final int DEFAULT_MIN_SIG = 1;
    private static final int DEFAULT_MAX_SIG = 2;
    private static final DecimalFormat.SignificantDigitsMode DEFAULT_SIG_MODE = DecimalFormat.SignificantDigitsMode.OVERRIDE_MAXIMUM_FRACTION;
    private static final ThreadLocal<Properties> threadLocalProperties = new ThreadLocal<Properties>(){

        @Override
        protected Properties initialValue() {
            return new Properties();
        }
    };
    protected static final ThreadLocal<Map<CompactDecimalFingerprint, CompactDecimalData>> threadLocalDataCache = new ThreadLocal<Map<CompactDecimalFingerprint, CompactDecimalData>>(){

        @Override
        protected Map<CompactDecimalFingerprint, CompactDecimalData> initialValue() {
            return new HashMap<CompactDecimalFingerprint, CompactDecimalData>();
        }
    };

    public static boolean useCompactDecimalFormat(IProperties properties) {
        return properties.getCompactStyle() != IProperties.DEFAULT_COMPACT_STYLE;
    }

    public static CompactDecimalFormat getInstance(DecimalFormatSymbols symbols2, IProperties properties) {
        return new CompactDecimalFormat(symbols2, properties);
    }

    private static Rounder getRounder(IProperties properties) {
        Rounder rounder = null;
        if (!SignificantDigitsRounder.useSignificantDigits(properties)) {
            rounder = RoundingFormat.getDefaultOrNull(properties);
        }
        if (rounder == null) {
            int _minSig = properties.getMinimumSignificantDigits();
            int _maxSig = properties.getMaximumSignificantDigits();
            DecimalFormat.SignificantDigitsMode _mode = properties.getSignificantDigitsMode();
            Properties rprops = threadLocalProperties.get().clear();
            rprops.setMinimumSignificantDigits(_minSig > 0 ? _minSig : 1);
            rprops.setMaximumSignificantDigits(_maxSig > 0 ? _maxSig : 2);
            rprops.setSignificantDigitsMode(_mode != null ? _mode : DEFAULT_SIG_MODE);
            rprops.setRoundingMode(properties.getRoundingMode());
            rprops.setMinimumFractionDigits(properties.getMinimumFractionDigits());
            rprops.setMaximumFractionDigits(properties.getMaximumFractionDigits());
            rprops.setMinimumIntegerDigits(properties.getMinimumIntegerDigits());
            rprops.setMaximumIntegerDigits(properties.getMaximumIntegerDigits());
            rounder = SignificantDigitsRounder.getInstance(rprops);
        }
        return rounder;
    }

    private static CompactDecimalData getData(DecimalFormatSymbols symbols2, CompactDecimalFingerprint fingerprint) {
        CompactDecimalData data = threadLocalDataCache.get().get(fingerprint);
        if (data != null) {
            return data;
        }
        data = new CompactDecimalData();
        ULocale ulocale = symbols2.getULocale();
        CompactDecimalDataSink sink = new CompactDecimalDataSink(data, symbols2, fingerprint);
        String nsName = NumberingSystem.getInstance(ulocale).getName();
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt59b", ulocale);
        CompactDecimalFormat.internalPopulateData(nsName, rb, sink, data);
        if (data.isEmpty() && fingerprint.compactStyle == CompactDecimalFormat.CompactStyle.LONG) {
            sink.compactStyle = CompactDecimalFormat.CompactStyle.SHORT;
            CompactDecimalFormat.internalPopulateData(nsName, rb, sink, data);
        }
        threadLocalDataCache.get().put(fingerprint, data);
        return data;
    }

    private static void internalPopulateData(String nsName, ICUResourceBundle rb, CompactDecimalDataSink sink, CompactDecimalData data) {
        try {
            rb.getAllItemsWithFallback("NumberElements/" + nsName, sink);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (data.isEmpty() && !nsName.equals("latn")) {
            rb.getAllItemsWithFallback("NumberElements/latn", sink);
        }
        if (sink.exception != null) {
            throw sink.exception;
        }
    }

    private static Modifier.PositiveNegativeModifier getDefaultMod(DecimalFormatSymbols symbols2, CompactDecimalFingerprint fingerprint) {
        ULocale uloc = symbols2.getULocale();
        String pattern = fingerprint.compactType == CompactType.CURRENCY ? NumberFormat.getPatternForStyle(uloc, 1) : NumberFormat.getPatternForStyle(uloc, 0);
        Properties properties = PatternString.parseToProperties(pattern);
        PNAffixGenerator pnag = PNAffixGenerator.getThreadLocalInstance();
        PNAffixGenerator.Result result2 = pnag.getModifiers(symbols2, fingerprint.currencySymbol, properties);
        return new PositiveNegativeAffixModifier(result2.positive, result2.negative);
    }

    private CompactDecimalFormat(DecimalFormatSymbols symbols2, IProperties properties) {
        CompactDecimalFingerprint fingerprint = new CompactDecimalFingerprint(symbols2, properties);
        this.rounder = CompactDecimalFormat.getRounder(properties);
        this.data = CompactDecimalFormat.getData(symbols2, fingerprint);
        this.defaultMod = CompactDecimalFormat.getDefaultMod(symbols2, fingerprint);
        this.style = properties.getCompactStyle();
    }

    @Override
    public void before(FormatQuantity input, ModifierHolder mods, PluralRules rules) {
        CompactDecimalFormat.apply(input, mods, rules, this.rounder, this.data, this.defaultMod);
    }

    @Override
    protected void before(FormatQuantity input, ModifierHolder mods) {
        throw new UnsupportedOperationException();
    }

    public static void apply(FormatQuantity input, ModifierHolder mods, PluralRules rules, DecimalFormatSymbols symbols2, IProperties properties) {
        CompactDecimalFingerprint fingerprint = new CompactDecimalFingerprint(symbols2, properties);
        Rounder rounder = CompactDecimalFormat.getRounder(properties);
        CompactDecimalData data = CompactDecimalFormat.getData(symbols2, fingerprint);
        Modifier.PositiveNegativeModifier defaultMod = CompactDecimalFormat.getDefaultMod(symbols2, fingerprint);
        CompactDecimalFormat.apply(input, mods, rules, rounder, data, defaultMod);
    }

    private static void apply(FormatQuantity input, ModifierHolder mods, PluralRules rules, Rounder rounder, CompactDecimalData data, Modifier.PositiveNegativeModifier defaultMod) {
        int magnitude;
        if (input.isZero()) {
            magnitude = 0;
            rounder.apply(input);
        } else {
            int multiplier = rounder.chooseMultiplierAndApply(input, data);
            magnitude = input.getMagnitude() - multiplier;
        }
        StandardPlural plural = input.getStandardPlural(rules);
        boolean isNegative = input.isNegative();
        Modifier mod2 = data.getModifier(magnitude, plural, isNegative);
        if (mod2 == null) {
            mod2 = defaultMod.getModifier(isNegative);
        }
        mods.add(mod2);
    }

    @Override
    public void export(Properties properties) {
        properties.setCompactStyle(this.style);
        this.rounder.export(properties);
    }

    private static final class CompactDecimalDataSink
    extends UResource.Sink {
        CompactDecimalData data;
        DecimalFormatSymbols symbols;
        CompactDecimalFormat.CompactStyle compactStyle;
        CompactType compactType;
        String currencySymbol;
        PNAffixGenerator pnag;
        IllegalArgumentException exception;

        public CompactDecimalDataSink(CompactDecimalData data, DecimalFormatSymbols symbols2, CompactDecimalFingerprint fingerprint) {
            this.data = data;
            this.symbols = symbols2;
            this.compactType = fingerprint.compactType;
            this.currencySymbol = fingerprint.currencySymbol;
            this.compactStyle = fingerprint.compactStyle;
            this.pnag = PNAffixGenerator.getThreadLocalInstance();
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean isRoot) {
            UResource.Table patternsTable = value.getTable();
            int i1 = 0;
            while (patternsTable.getKeyAndValue(i1, key, value)) {
                if (key.contentEquals("patternsShort") && this.compactStyle == CompactDecimalFormat.CompactStyle.SHORT || key.contentEquals("patternsLong") && this.compactStyle == CompactDecimalFormat.CompactStyle.LONG) {
                    UResource.Table formatsTable = value.getTable();
                    int i2 = 0;
                    while (formatsTable.getKeyAndValue(i2, key, value)) {
                        if (key.contentEquals("decimalFormat") && this.compactType == CompactType.DECIMAL || key.contentEquals("currencyFormat") && this.compactType == CompactType.CURRENCY) {
                            UResource.Table powersOfTenTable = value.getTable();
                            int i3 = 0;
                            while (powersOfTenTable.getKeyAndValue(i3, key, value)) {
                                try {
                                    byte magnitude = (byte)(key.length() - 1);
                                    if (magnitude < 15) {
                                        UResource.Table pluralVariantsTable = value.getTable();
                                        int i4 = 0;
                                        while (pluralVariantsTable.getKeyAndValue(i4, key, value)) {
                                            StandardPlural plural = StandardPlural.fromString(key.toString());
                                            if (!this.data.has(magnitude, plural)) {
                                                String patternString = value.toString();
                                                if (patternString.equals("0")) {
                                                    this.data.setNoFallback(magnitude, plural);
                                                } else {
                                                    Properties properties = PatternString.parseToProperties(patternString);
                                                    byte _multiplier = (byte)(-(magnitude - properties.getMinimumIntegerDigits() + 1));
                                                    if (_multiplier != this.data.setOrGetMultiplier(magnitude, _multiplier)) {
                                                        throw new IllegalArgumentException(String.format("Different number of zeros for same power of ten in compact decimal format data for locale '%s', style '%s', type '%s'", this.symbols.getULocale().toString(), this.compactStyle.toString(), this.compactType.toString()));
                                                    }
                                                    PNAffixGenerator.Result result2 = this.pnag.getModifiers(this.symbols, this.currencySymbol, properties);
                                                    this.data.setModifiers(result2.positive, result2.negative, magnitude, plural);
                                                }
                                            }
                                            ++i4;
                                        }
                                    }
                                }
                                catch (IllegalArgumentException e) {
                                    this.exception = e;
                                }
                                ++i3;
                            }
                            return;
                        }
                        ++i2;
                    }
                }
                ++i1;
            }
        }
    }

    static class CompactDecimalFingerprint {
        final CompactDecimalFormat.CompactStyle compactStyle;
        final CompactType compactType;
        final ULocale uloc;
        final String currencySymbol;

        CompactDecimalFingerprint(DecimalFormatSymbols symbols2, IProperties properties) {
            if (properties.getCurrency() != CurrencyFormat.ICurrencyProperties.DEFAULT_CURRENCY) {
                this.compactType = CompactType.CURRENCY;
                this.currencySymbol = CurrencyFormat.getCurrencySymbol(symbols2, properties);
            } else {
                this.compactType = CompactType.DECIMAL;
                this.currencySymbol = "";
            }
            this.compactStyle = properties.getCompactStyle();
            this.uloc = symbols2.getULocale();
        }

        public boolean equals(Object _other) {
            if (_other == null) {
                return false;
            }
            CompactDecimalFingerprint other = (CompactDecimalFingerprint)_other;
            if (this == other) {
                return true;
            }
            if (this.compactStyle != other.compactStyle) {
                return false;
            }
            if (this.compactType != other.compactType) {
                return false;
            }
            if (this.currencySymbol != other.currencySymbol) {
                if (this.currencySymbol == null || other.currencySymbol == null) {
                    return false;
                }
                if (!this.currencySymbol.equals(other.currencySymbol)) {
                    return false;
                }
            }
            return this.uloc.equals(other.uloc);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.compactStyle != null) {
                hashCode ^= this.compactStyle.hashCode();
            }
            if (this.compactType != null) {
                hashCode ^= this.compactType.hashCode();
            }
            if (this.uloc != null) {
                hashCode ^= this.uloc.hashCode();
            }
            if (this.currencySymbol != null) {
                hashCode ^= this.currencySymbol.hashCode();
            }
            return hashCode;
        }
    }

    static enum CompactType {
        DECIMAL,
        CURRENCY;

    }

    static class CompactDecimalData
    implements Rounder.MultiplierGenerator {
        private static final Modifier USE_FALLBACK = new ConstantAffixModifier();
        final Modifier[] mods = new Modifier[16 * StandardPlural.COUNT * 2];
        final byte[] multipliers = new byte[16];
        boolean isEmpty = true;
        int largestMagnitude = -1;

        CompactDecimalData() {
        }

        boolean isEmpty() {
            return this.isEmpty;
        }

        @Override
        public int getMultiplier(int magnitude) {
            if (magnitude < 0) {
                return 0;
            }
            if (magnitude > this.largestMagnitude) {
                magnitude = this.largestMagnitude;
            }
            return this.multipliers[magnitude];
        }

        int setOrGetMultiplier(int magnitude, byte multiplier) {
            if (this.multipliers[magnitude] != 0) {
                return this.multipliers[magnitude];
            }
            this.multipliers[magnitude] = multiplier;
            this.isEmpty = false;
            if (magnitude > this.largestMagnitude) {
                this.largestMagnitude = magnitude;
            }
            return multiplier;
        }

        Modifier getModifier(int magnitude, StandardPlural plural, boolean isNegative) {
            Modifier mod2;
            if (magnitude < 0) {
                return null;
            }
            if (magnitude > this.largestMagnitude) {
                magnitude = this.largestMagnitude;
            }
            if ((mod2 = this.mods[CompactDecimalData.modIndex(magnitude, plural, isNegative)]) == null && plural != StandardPlural.OTHER) {
                mod2 = this.mods[CompactDecimalData.modIndex(magnitude, StandardPlural.OTHER, isNegative)];
            }
            if (mod2 == USE_FALLBACK) {
                mod2 = null;
            }
            return mod2;
        }

        public boolean has(int magnitude, StandardPlural plural) {
            return this.mods[CompactDecimalData.modIndex(magnitude, plural, false)] != null;
        }

        void setModifiers(Modifier positive, Modifier negative, int magnitude, StandardPlural plural) {
            this.mods[CompactDecimalData.modIndex((int)magnitude, (StandardPlural)plural, (boolean)false)] = positive;
            this.mods[CompactDecimalData.modIndex((int)magnitude, (StandardPlural)plural, (boolean)true)] = negative;
            this.isEmpty = false;
            if (magnitude > this.largestMagnitude) {
                this.largestMagnitude = magnitude;
            }
        }

        void setNoFallback(int magnitude, StandardPlural plural) {
            this.setModifiers(USE_FALLBACK, USE_FALLBACK, magnitude, plural);
        }

        private static final int modIndex(int magnitude, StandardPlural plural, boolean isNegative) {
            return magnitude * StandardPlural.COUNT * 2 + plural.ordinal() * 2 + (isNegative ? 1 : 0);
        }
    }

    public static interface IProperties
    extends RoundingFormat.IProperties,
    CurrencyFormat.ICurrencyProperties {
        public static final CompactDecimalFormat.CompactStyle DEFAULT_COMPACT_STYLE = null;

        public CompactDecimalFormat.CompactStyle getCompactStyle();

        public IProperties setCompactStyle(CompactDecimalFormat.CompactStyle var1);
    }
}

