/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.drivers.OperationTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.ExistsBuilderMain;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CreateBuilderImpl;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.Watching;
import org.apache.curator.utils.InternalACLProvider;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

class ExistsBuilderImpl
implements ExistsBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<Stat> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Watching watching;
    private boolean createParentContainersIfNeeded;

    ExistsBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.watching = new Watching();
        this.createParentContainersIfNeeded = false;
    }

    @Override
    public ExistsBuilderMain creatingParentContainersIfNeeded() {
        this.createParentContainersIfNeeded = true;
        return this;
    }

    @Override
    public BackgroundPathable<Stat> watched() {
        this.watching = new Watching(true);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public BackgroundPathable<Stat> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<Stat> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("ExistsBuilderImpl-Background");
            AsyncCallback.StatCallback callback = new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    trace.setReturnCode(rc).setPath(path).setWithWatcher(ExistsBuilderImpl.this.watching.getWatcher() != null).setStat(stat).commit();
                    CuratorEventImpl event = new CuratorEventImpl(ExistsBuilderImpl.this.client, CuratorEventType.EXISTS, rc, path, null, ctx, stat, null, null, null, null);
                    ExistsBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            };
            if (this.watching.isWatched()) {
                this.client.getZooKeeper().exists(operationAndData.getData(), true, callback, this.backgrounding.getContext());
            } else {
                this.client.getZooKeeper().exists(operationAndData.getData(), this.watching.getWatcher(), callback, this.backgrounding.getContext());
            }
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e);
        }
    }

    @Override
    public Stat forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        Stat returnStat = null;
        if (this.backgrounding.inBackground()) {
            OperationAndData<String> operationAndData = new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext());
            if (this.createParentContainersIfNeeded) {
                CreateBuilderImpl.backgroundCreateParentsThenNode(this.client, operationAndData, operationAndData.getData(), this.backgrounding, true);
            } else {
                this.client.processBackgroundOperation(operationAndData, null);
            }
        } else {
            returnStat = this.pathInForeground(path);
        }
        return returnStat;
    }

    private Stat pathInForeground(String path) throws Exception {
        String parent;
        if (this.createParentContainersIfNeeded && !(parent = ZKPaths.getPathAndNode((String)path).getPath()).equals("/")) {
            OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("ExistsBuilderImpl-Foreground-CreateParents");
            RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        ZKPaths.mkdirs((ZooKeeper)ExistsBuilderImpl.this.client.getZooKeeper(), (String)parent, (boolean)true, (InternalACLProvider)ExistsBuilderImpl.this.client.getAclProvider(), (boolean)true);
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            trace.setPath(path).commit();
        }
        return this.pathInForegroundStandard(path);
    }

    private Stat pathInForegroundStandard(final String path) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("ExistsBuilderImpl-Foreground");
        Stat returnStat = (Stat)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                Stat returnStat = ExistsBuilderImpl.this.watching.isWatched() ? ExistsBuilderImpl.this.client.getZooKeeper().exists(path, true) : ExistsBuilderImpl.this.client.getZooKeeper().exists(path, ExistsBuilderImpl.this.watching.getWatcher());
                return returnStat;
            }
        });
        trace.setPath(path).setWithWatcher(this.watching.getWatcher() != null).setStat(returnStat).commit();
        return returnStat;
    }
}

