/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.SerializedExceptionPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class StartContainersResponsePBImpl
extends StartContainersResponse {
    YarnServiceProtos.StartContainersResponseProto proto = YarnServiceProtos.StartContainersResponseProto.getDefaultInstance();
    YarnServiceProtos.StartContainersResponseProto.Builder builder = null;
    boolean viaProto = false;
    private Map<String, ByteBuffer> servicesMetaData = null;
    private List<ContainerId> succeededContainers = null;
    private Map<ContainerId, SerializedException> failedContainers = null;

    public StartContainersResponsePBImpl() {
        this.builder = YarnServiceProtos.StartContainersResponseProto.newBuilder();
    }

    public StartContainersResponsePBImpl(YarnServiceProtos.StartContainersResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.StartContainersResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((StartContainersResponsePBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.servicesMetaData != null) {
            this.addServicesMetaDataToProto();
        }
        if (this.succeededContainers != null) {
            this.addSucceededContainersToProto();
        }
        if (this.failedContainers != null) {
            this.addFailedContainersToProto();
        }
    }

    protected final ByteBuffer convertFromProtoFormat(ByteString byteString) {
        return ProtoUtils.convertFromProtoFormat(byteString);
    }

    protected final ByteString convertToProtoFormat(ByteBuffer byteBuffer) {
        return ProtoUtils.convertToProtoFormat(byteBuffer);
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private SerializedExceptionPBImpl convertFromProtoFormat(YarnProtos.SerializedExceptionProto p) {
        return new SerializedExceptionPBImpl(p);
    }

    private YarnProtos.SerializedExceptionProto convertToProtoFormat(SerializedException t) {
        return ((SerializedExceptionPBImpl)t).getProto();
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.StartContainersResponseProto.newBuilder((YarnServiceProtos.StartContainersResponseProto)this.proto);
        }
        this.viaProto = false;
    }

    public Map<String, ByteBuffer> getAllServicesMetaData() {
        this.initServicesMetaData();
        return this.servicesMetaData;
    }

    public void setAllServicesMetaData(Map<String, ByteBuffer> servicesMetaData) {
        if (servicesMetaData == null) {
            return;
        }
        this.initServicesMetaData();
        this.servicesMetaData.clear();
        this.servicesMetaData.putAll(servicesMetaData);
    }

    private void initServicesMetaData() {
        if (this.servicesMetaData != null) {
            return;
        }
        YarnServiceProtos.StartContainersResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getServicesMetaDataList();
        this.servicesMetaData = new HashMap<String, ByteBuffer>();
        for (YarnProtos.StringBytesMapProto c : list) {
            this.servicesMetaData.put(c.getKey(), this.convertFromProtoFormat(c.getValue()));
        }
    }

    private void addServicesMetaDataToProto() {
        this.maybeInitBuilder();
        this.builder.clearServicesMetaData();
        if (this.servicesMetaData == null) {
            return;
        }
        Iterable<YarnProtos.StringBytesMapProto> iterable = new Iterable<YarnProtos.StringBytesMapProto>(){

            @Override
            public Iterator<YarnProtos.StringBytesMapProto> iterator() {
                return new Iterator<YarnProtos.StringBytesMapProto>(){
                    Iterator<String> keyIter;
                    {
                        this.keyIter = StartContainersResponsePBImpl.this.servicesMetaData.keySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnProtos.StringBytesMapProto next() {
                        String key = this.keyIter.next();
                        return YarnProtos.StringBytesMapProto.newBuilder().setKey(key).setValue(StartContainersResponsePBImpl.this.convertToProtoFormat((ByteBuffer)StartContainersResponsePBImpl.this.servicesMetaData.get(key))).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllServicesMetaData((Iterable)iterable);
    }

    private void addFailedContainersToProto() {
        this.maybeInitBuilder();
        this.builder.clearFailedRequests();
        if (this.failedContainers == null) {
            return;
        }
        ArrayList<YarnServiceProtos.ContainerExceptionMapProto> protoList = new ArrayList<YarnServiceProtos.ContainerExceptionMapProto>();
        for (Map.Entry<ContainerId, SerializedException> entry : this.failedContainers.entrySet()) {
            protoList.add(YarnServiceProtos.ContainerExceptionMapProto.newBuilder().setContainerId(this.convertToProtoFormat(entry.getKey())).setException(this.convertToProtoFormat(entry.getValue())).build());
        }
        this.builder.addAllFailedRequests(protoList);
    }

    private void addSucceededContainersToProto() {
        this.maybeInitBuilder();
        this.builder.clearSucceededRequests();
        if (this.succeededContainers == null) {
            return;
        }
        Iterable<YarnProtos.ContainerIdProto> iterable = new Iterable<YarnProtos.ContainerIdProto>(){

            @Override
            public Iterator<YarnProtos.ContainerIdProto> iterator() {
                return new Iterator<YarnProtos.ContainerIdProto>(){
                    Iterator<ContainerId> iter;
                    {
                        this.iter = StartContainersResponsePBImpl.this.succeededContainers.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerIdProto next() {
                        return StartContainersResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllSucceededRequests((Iterable)iterable);
    }

    private void initSucceededContainers() {
        if (this.succeededContainers != null) {
            return;
        }
        YarnServiceProtos.StartContainersResponseProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getSucceededRequestsList();
        this.succeededContainers = new ArrayList<ContainerId>();
        for (YarnProtos.ContainerIdProto c : list) {
            this.succeededContainers.add(this.convertFromProtoFormat(c));
        }
    }

    public List<ContainerId> getSuccessfullyStartedContainers() {
        this.initSucceededContainers();
        return this.succeededContainers;
    }

    public void setSuccessfullyStartedContainers(List<ContainerId> succeededContainers) {
        this.maybeInitBuilder();
        if (succeededContainers == null) {
            this.builder.clearSucceededRequests();
        }
        this.succeededContainers = succeededContainers;
    }

    private void initFailedContainers() {
        if (this.failedContainers != null) {
            return;
        }
        YarnServiceProtos.StartContainersResponseProto p = this.viaProto ? this.proto : this.builder;
        List protoList = p.getFailedRequestsList();
        this.failedContainers = new HashMap<ContainerId, SerializedException>();
        for (YarnServiceProtos.ContainerExceptionMapProto ce : protoList) {
            this.failedContainers.put(this.convertFromProtoFormat(ce.getContainerId()), this.convertFromProtoFormat(ce.getException()));
        }
    }

    public Map<ContainerId, SerializedException> getFailedRequests() {
        this.initFailedContainers();
        return this.failedContainers;
    }

    public void setFailedRequests(Map<ContainerId, SerializedException> failedContainers) {
        this.maybeInitBuilder();
        if (failedContainers == null) {
            this.builder.clearFailedRequests();
        }
        this.failedContainers = failedContainers;
    }
}

