/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class POShuffledValueInputTez
extends PhysicalOperator
implements TezInput {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POShuffledValueInputTez.class);
    private Set<String> inputKeys = new HashSet<String>();
    private transient boolean finished = false;
    private transient Iterator<KeyValueReader> readers;
    private transient KeyValueReader currentReader;
    private transient Configuration conf;
    private transient Boolean hasFirstRecord;

    public POShuffledValueInputTez(OperatorKey k) {
        super(k);
    }

    @Override
    public String[] getTezInputs() {
        return this.inputKeys.toArray(new String[this.inputKeys.size()]);
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        while (this.inputKeys.remove(oldInputKey)) {
            this.inputKeys.add(newInputKey);
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        this.conf = conf;
        ArrayList<KeyValueReader> readersList = new ArrayList<KeyValueReader>();
        try {
            for (String inputKey : this.inputKeys) {
                LogicalInput input = inputs.get(inputKey);
                if (input == null) {
                    throw new ExecException("Input from vertex " + inputKey + " is missing");
                }
                KeyValueReader reader = (KeyValueReader)input.getReader();
                readersList.add(reader);
                LOG.info((Object)("Attached input from vertex " + inputKey + " : input=" + input + ", reader=" + reader));
            }
            this.readers = readersList.iterator();
            this.currentReader = this.readers.next();
            this.hasFirstRecord = this.currentReader.next();
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        try {
            if (this.finished) {
                return RESULT_EOP;
            }
            do {
                if (this.hasFirstRecord != null) {
                    if (this.hasFirstRecord.booleanValue()) {
                        this.hasFirstRecord = null;
                        Tuple origTuple = (Tuple)this.currentReader.getCurrentValue();
                        Tuple copy = mTupleFactory.newTuple(origTuple.getAll());
                        return new Result(0, copy);
                    }
                    this.hasFirstRecord = null;
                } else if (this.currentReader.next()) {
                    Tuple origTuple = (Tuple)this.currentReader.getCurrentValue();
                    Tuple copy = mTupleFactory.newTuple(origTuple.getAll());
                    return new Result(0, copy);
                }
                KeyValueReader keyValueReader = this.currentReader = this.readers.hasNext() ? this.readers.next() : null;
            } while (this.currentReader != null);
            this.finished = true;
            if (Boolean.valueOf(this.conf.get("pig.invoke.close.in.map", "false")).booleanValue()) {
                this.parentPlan.endOfAllInput = true;
            }
            return RESULT_EOP;
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
    }

    public void addInputKey(String inputKey) {
        this.inputKeys.add(inputKey);
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        ArrayList<String> inputKeyList = new ArrayList<String>(this.inputKeys);
        Collections.sort(inputKeyList);
        return "POShuffledValueInputTez - " + this.mKey.toString() + "\t<-\t " + inputKeyList;
    }
}

