/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataType;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DataByteArray
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    byte[] mData = null;

    public DataByteArray() {
    }

    public DataByteArray(byte[] b) {
        this.mData = b;
    }

    public DataByteArray(DataByteArray b, DataByteArray c) {
        byte[] ba = b == null ? null : b.get();
        byte[] ca = c == null ? null : c.get();
        int baLength = ba == null ? 0 : ba.length;
        int caLength = ca == null ? 0 : ca.length;
        int totalSize = baLength + caLength;
        if (totalSize == 0) {
            return;
        }
        this.mData = new byte[totalSize];
        System.arraycopy(ba, 0, this.mData, 0, baLength);
        System.arraycopy(ca, 0, this.mData, baLength, caLength);
    }

    public DataByteArray(byte[] b, int start, int end) {
        this.mData = new byte[end - start];
        System.arraycopy(b, start, this.mData, 0, end - start);
    }

    public DataByteArray(String s) {
        try {
            this.mData = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public int size() {
        return this.mData.length;
    }

    public byte[] get() {
        return this.mData;
    }

    public void set(byte[] b) {
        this.mData = b;
    }

    public void set(String s) {
        this.mData = s.getBytes();
    }

    public DataByteArray append(DataByteArray b) {
        byte[] ba = b == null ? null : b.get();
        return this.append(ba, 0, ba == null ? 0 : ba.length);
    }

    public DataByteArray append(byte[] ba) {
        return this.append(ba, 0, ba.length);
    }

    public DataByteArray append(byte[] ba, int start, int baLength) {
        int mDataLength = this.mData == null ? 0 : this.mData.length;
        int totalSize = mDataLength + baLength;
        if (totalSize == 0) {
            return this;
        }
        byte[] oldData = this.mData == null ? new byte[]{} : (byte[])this.mData.clone();
        this.mData = new byte[totalSize];
        System.arraycopy(oldData, 0, this.mData, 0, mDataLength);
        System.arraycopy(ba, start, this.mData, mDataLength, baLength);
        return this;
    }

    public DataByteArray append(String str) {
        try {
            return this.append(str.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to append str: " + str);
        }
    }

    public String toString() {
        String r = "";
        try {
            r = new String(this.mData, "UTF8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    public int compareTo(Object other) {
        if (other instanceof DataByteArray) {
            DataByteArray dba = (DataByteArray)other;
            return DataByteArray.compare(this.mData, dba.mData);
        }
        return DataType.compare(this, other);
    }

    public static int compare(byte[] b1, byte[] b2) {
        return WritableComparator.compareBytes((byte[])b1, (int)0, (int)b1.length, (byte[])b2, (int)0, (int)b2.length);
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return DataByteArray.hashCode(this.mData);
    }

    public static int hashCode(byte[] buf) {
        return Arrays.hashCode(buf);
    }
}

