/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.hive;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.minlog.Log;
import io.airlift.compress.Decompressor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.security.LlapSigner;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapreduce.Job;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.joda.time.DateTime;
import org.threeten.extra.chrono.AccountingDate;

public class HiveShims {
    public static String normalizeOrcVersionName(String version) {
        return OrcFile.Version.byName((String)version).getName();
    }

    public static void addLessThanOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object value) {
        builder.lessThan(columnName, columnType, value);
    }

    public static void addLessThanEqualsOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object value) {
        builder.lessThanEquals(columnName, columnType, value);
    }

    public static void addEqualsOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object value) {
        builder.equals(columnName, columnType, value);
    }

    public static void addBetweenOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object low, Object high) {
        builder.between(columnName, columnType, low, high);
    }

    public static void addIsNullOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType) {
        builder.isNull(columnName, columnType);
    }

    public static Class[] getOrcDependentClasses(Class hadoopVersionShimsClass) {
        return new Class[]{org.apache.hadoop.hive.ql.io.orc.OrcFile.class, HiveConf.class, AbstractSerDe.class, HadoopShims.class, HadoopShimsSecure.class, DateWritable.class, hadoopVersionShimsClass, Input.class, OrcFile.class, Log.class, org.apache.orc.impl.HadoopShims.class, Decompressor.class, AccountingDate.class};
    }

    public static Class[] getHiveUDFDependentClasses(Class hadoopVersionShimsClass) {
        return new Class[]{GenericUDF.class, PrimitiveObjectInspector.class, HiveConf.class, Serializer.class, ShimLoader.class, hadoopVersionShimsClass, HadoopShimsSecure.class, Collector.class, HiveDecimalWritable.class, LlapSigner.class};
    }

    public static Object getSearchArgObjValue(Object value) {
        if (value instanceof Integer) {
            return new Long(((Integer)value).intValue());
        }
        if (value instanceof Float) {
            return new Double(((Float)value).floatValue());
        }
        if (value instanceof BigInteger) {
            return new HiveDecimalWritable(HiveDecimal.create((BigInteger)((BigInteger)value)));
        }
        if (value instanceof BigDecimal) {
            return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)value)));
        }
        if (value instanceof DateTime) {
            return new Date(((DateTime)value).getMillis());
        }
        return value;
    }

    public static void setOrcConfigOnJob(Job job, Long stripeSize, Integer rowIndexStride, Integer bufferSize, Boolean blockPadding, CompressionKind compress, String versionName) {
        if (stripeSize != null) {
            job.getConfiguration().setLong(OrcConf.STRIPE_SIZE.getAttribute(), stripeSize.longValue());
        }
        if (rowIndexStride != null) {
            job.getConfiguration().setInt(OrcConf.ROW_INDEX_STRIDE.getAttribute(), rowIndexStride.intValue());
        }
        if (bufferSize != null) {
            job.getConfiguration().setInt(OrcConf.BUFFER_SIZE.getAttribute(), bufferSize.intValue());
        }
        if (blockPadding != null) {
            job.getConfiguration().setBoolean(OrcConf.BLOCK_PADDING.getAttribute(), blockPadding.booleanValue());
        }
        if (compress != null) {
            job.getConfiguration().set(OrcConf.COMPRESS.getAttribute(), compress.toString());
        }
        if (versionName != null) {
            job.getConfiguration().set(OrcConf.WRITE_FORMAT.getAttribute(), versionName);
        }
    }

    public static GenericUDAFParameterInfo newSimpleGenericUDAFParameterInfo(ObjectInspector[] arguments, boolean distinct, boolean allColumns) {
        return new SimpleGenericUDAFParameterInfo(arguments, false, distinct, allColumns);
    }

    public static class TimestampWritableShim {
        public static boolean isAssignableFrom(Object object) {
            return object instanceof TimestampWritableV2;
        }

        public static TimestampWritableV2 cast(Object ts) {
            return (TimestampWritableV2)ts;
        }

        public static long millisFromTimestampWritable(Object ts) {
            return TimestampWritableShim.cast(ts).getTimestamp().toEpochMilli();
        }
    }

    public static class TimestampShim {
        public static Timestamp cast(Object ts) {
            return (Timestamp)ts;
        }

        public static long millisFromTimestamp(Object ts) {
            return TimestampShim.cast(ts).toEpochMilli();
        }
    }

    public static class DateShim {
        public static org.apache.hadoop.hive.common.type.Date cast(Object ts) {
            return (org.apache.hadoop.hive.common.type.Date)ts;
        }

        public static long millisFromDate(Object ts) {
            return DateShim.cast(ts).toEpochMilli();
        }
    }

    public static class PigJodaTimeStampObjectInspector
    extends AbstractPrimitiveJavaObjectInspector
    implements TimestampObjectInspector {
        public PigJodaTimeStampObjectInspector() {
            super(TypeInfoFactory.timestampTypeInfo);
        }

        private static Timestamp getHiveTimeStampFromDateTime(Object o) {
            if (o == null) {
                return null;
            }
            Timestamp ts = new Timestamp();
            ts.setTimeInMillis(((DateTime)o).getMillis());
            return ts;
        }

        public TimestampWritableV2 getPrimitiveWritableObject(Object o) {
            return o == null ? null : new TimestampWritableV2(PigJodaTimeStampObjectInspector.getHiveTimeStampFromDateTime(o));
        }

        public Timestamp getPrimitiveJavaObject(Object o) {
            return o == null ? null : new Timestamp(PigJodaTimeStampObjectInspector.getHiveTimeStampFromDateTime(o));
        }
    }
}

