/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.io.Serializable;
import org.apache.pig.impl.plan.NodeIdGenerator;

public class OperatorKey
implements Serializable,
Comparable<OperatorKey> {
    private static final long serialVersionUID = 1L;
    public String scope;
    public long id;

    public OperatorKey() {
        this("", -1L);
    }

    public OperatorKey(String scope, long id) {
        this.scope = scope;
        this.id = id;
    }

    public String toString() {
        return this.scope + "-" + this.id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OperatorKey)) {
            return false;
        }
        OperatorKey otherKey = (OperatorKey)obj;
        return this.scope.equals(otherKey.scope) && this.id == otherKey.id;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getScope() {
        return this.scope;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public int compareTo(OperatorKey o) {
        int scCmp = this.scope.compareTo(o.scope);
        if (scCmp != 0) {
            return scCmp;
        }
        if (this.id > o.id) {
            return 1;
        }
        if (this.id == o.id) {
            return 0;
        }
        return -1;
    }

    public static OperatorKey genOpKey(String scope) {
        return new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope));
    }

    public static OperatorKey fromString(String op) {
        String scope = op.substring(0, op.indexOf("-"));
        long id = Long.parseLong(op.substring(op.indexOf("-") + 1));
        return new OperatorKey(scope, id);
    }
}

