/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli;

import org.apache.hadoop.cli.CLITestHelperDFS;
import org.apache.hadoop.cli.util.CLICommand;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDeleteCLI
extends CLITestHelperDFS {
    protected MiniDFSCluster dfsCluster = null;
    protected FileSystem fs = null;
    protected String namenode = null;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf.setInt("dfs.replication", 1);
        this.conf.setLong("hadoop.shell.safely.delete.limit.num.files", 5L);
        this.dfsCluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.dfsCluster.waitClusterUp();
        this.namenode = this.conf.get("fs.defaultFS", "file:///");
        this.fs = this.dfsCluster.getFileSystem();
        Assert.assertTrue((String)("Not an HDFS: " + this.fs.getUri()), (boolean)(this.fs instanceof DistributedFileSystem));
    }

    @After
    public void tearDown() throws Exception {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
            this.dfsCluster = null;
        }
        Thread.sleep(2000L);
        super.tearDown();
    }

    protected String getTestFile() {
        return "testDeleteConf.xml";
    }

    protected String expandCommand(String cmd) {
        String expCmd = cmd;
        expCmd = expCmd.replaceAll("NAMENODE", this.namenode);
        expCmd = super.expandCommand(expCmd);
        return expCmd;
    }

    protected CommandExecutor.Result execute(CLICommand cmd) throws Exception {
        return cmd.getExecutor(this.namenode, this.conf).executeCommand(cmd.getCmd());
    }

    @Test
    public void testAll() {
        super.testAll();
    }
}

