/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFsDefaultValue {
    static final String testFileDir = "/tmp/test/";
    static final String testFileName = "/tmp/test/testFileStatusSerialziation";
    static final String NOT_IN_MOUNTPOINT_FILENAME = "/NotInMountpointFile";
    private static MiniDFSCluster cluster;
    private static final FileSystemTestHelper fileSystemTestHelper;
    private static final Configuration CONF;
    private static FileSystem fHdfs;
    private static FileSystem vfs;
    private static Path testFilePath;
    private static Path testFileDirPath;
    private static Path notInMountpointPath;

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        CONF.setLong("dfs.blocksize", 0x8000000L);
        CONF.setInt("dfs.bytes-per-checksum", 512);
        CONF.setInt("dfs.client-write-packet-size", 65536);
        CONF.setInt("dfs.replication", 4);
        CONF.setInt("io.file.buffer.size", 4096);
        cluster = new MiniDFSCluster.Builder(CONF).numDataNodes(4).build();
        cluster.waitClusterUp();
        fHdfs = cluster.getFileSystem();
        fileSystemTestHelper.createFile(fHdfs, testFileName);
        fileSystemTestHelper.createFile(fHdfs, NOT_IN_MOUNTPOINT_FILENAME);
        Configuration conf = ViewFileSystemTestSetup.createConfig();
        conf.setInt("dfs.replication", 4);
        ConfigUtil.addLink((Configuration)conf, (String)"/tmp", (URI)new URI(fHdfs.getUri().toString() + "/tmp"));
        vfs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        testFileDirPath = new Path(testFileDir);
        testFilePath = new Path(testFileName);
        notInMountpointPath = new Path(NOT_IN_MOUNTPOINT_FILENAME);
    }

    @Test
    public void testGetDefaultBlockSize() throws IOException, URISyntaxException {
        try {
            vfs.getDefaultBlockSize(notInMountpointPath);
            Assert.fail((String)"getServerDefaults on viewFs did not throw excetion!");
        }
        catch (NotInMountpointException e) {
            Assert.assertEquals((long)vfs.getDefaultBlockSize(testFilePath), (long)0x8000000L);
        }
    }

    @Test
    public void testGetDefaultReplication() throws IOException, URISyntaxException {
        try {
            vfs.getDefaultReplication(notInMountpointPath);
            Assert.fail((String)"getDefaultReplication on viewFs did not throw excetion!");
        }
        catch (NotInMountpointException e) {
            Assert.assertEquals((long)vfs.getDefaultReplication(testFilePath), (long)4L);
        }
    }

    @Test
    public void testServerDefaults() throws IOException {
        try {
            vfs.getServerDefaults(notInMountpointPath);
            Assert.fail((String)"getServerDefaults on viewFs did not throw excetion!");
        }
        catch (NotInMountpointException e) {
            FsServerDefaults serverDefaults = vfs.getServerDefaults(testFilePath);
            Assert.assertEquals((long)0x8000000L, (long)serverDefaults.getBlockSize());
            Assert.assertEquals((long)512L, (long)serverDefaults.getBytesPerChecksum());
            Assert.assertEquals((long)65536L, (long)serverDefaults.getWritePacketSize());
            Assert.assertEquals((long)4096L, (long)serverDefaults.getFileBufferSize());
            Assert.assertEquals((long)4L, (long)serverDefaults.getReplication());
        }
    }

    @Test
    public void testGetContentSummary() throws IOException {
        DistributedFileSystem hFs;
        DistributedFileSystem dfs = hFs = cluster.getFileSystem(0);
        dfs.setQuota(testFileDirPath, 100L, 500L);
        ContentSummary cs = vfs.getContentSummary(testFileDirPath);
        Assert.assertEquals((long)100L, (long)cs.getQuota());
        Assert.assertEquals((long)500L, (long)cs.getSpaceQuota());
    }

    @Test
    public void testGetQuotaUsage() throws IOException {
        DistributedFileSystem hFs;
        DistributedFileSystem dfs = hFs = cluster.getFileSystem(0);
        dfs.setQuota(testFileDirPath, 100L, 500L);
        QuotaUsage qu = vfs.getQuotaUsage(testFileDirPath);
        Assert.assertEquals((long)100L, (long)qu.getQuota());
        Assert.assertEquals((long)500L, (long)qu.getSpaceQuota());
    }

    @Test
    public void testGetQuotaUsageWithStorageTypes() throws IOException {
        DistributedFileSystem hFs;
        DistributedFileSystem dfs = hFs = cluster.getFileSystem(0);
        dfs.setQuotaByStorageType(testFileDirPath, StorageType.SSD, 500L);
        dfs.setQuotaByStorageType(testFileDirPath, StorageType.DISK, 600L);
        QuotaUsage qu = vfs.getQuotaUsage(testFileDirPath);
        Assert.assertEquals((long)500L, (long)qu.getTypeQuota(StorageType.SSD));
        Assert.assertEquals((long)600L, (long)qu.getTypeQuota(StorageType.DISK));
    }

    @Test
    public void testGetQuotaUsageWithQuotaDefined() throws IOException {
        DistributedFileSystem hFs;
        DistributedFileSystem dfs = hFs = cluster.getFileSystem(0);
        dfs.setQuota(testFileDirPath, -1L, -1L);
        dfs.setQuotaByStorageType(testFileDirPath, StorageType.SSD, -1L);
        dfs.setQuotaByStorageType(testFileDirPath, StorageType.DISK, -1L);
        QuotaUsage qu = vfs.getQuotaUsage(testFileDirPath);
        Assert.assertEquals((long)-1L, (long)qu.getTypeQuota(StorageType.SSD));
        Assert.assertEquals((long)-1L, (long)qu.getQuota());
        Assert.assertEquals((long)-1L, (long)qu.getSpaceQuota());
        Assert.assertEquals((long)2L, (long)qu.getFileAndDirectoryCount());
        Assert.assertEquals((long)0L, (long)qu.getTypeConsumed(StorageType.SSD));
        Assert.assertTrue((qu.getSpaceConsumed() > 0L ? 1 : 0) != 0);
    }

    @AfterClass
    public static void cleanup() throws IOException {
        fHdfs.delete(new Path(testFileName), true);
        fHdfs.delete(notInMountpointPath, true);
    }

    static {
        fileSystemTestHelper = new FileSystemTestHelper();
        CONF = new Configuration();
    }
}

