/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AuthenticationKey
implements Writable {
    private volatile int id;
    private volatile long expirationDate;
    private volatile SecretKey secret;

    public AuthenticationKey() {
    }

    public AuthenticationKey(int keyId, long expirationDate, SecretKey key) {
        this.id = keyId;
        this.expirationDate = expirationDate;
        this.secret = key;
    }

    public int getKeyId() {
        return this.id;
    }

    public long getExpiration() {
        return this.expirationDate;
    }

    public void setExpiration(long timestamp) {
        this.expirationDate = timestamp;
    }

    SecretKey getKey() {
        return this.secret;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (int)(this.expirationDate ^ this.expirationDate >>> 32);
        result = 31 * result + (this.secret == null ? 0 : Arrays.hashCode(this.secret.getEncoded()));
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AuthenticationKey)) {
            return false;
        }
        AuthenticationKey other = (AuthenticationKey)obj;
        return this.id == other.getKeyId() && this.expirationDate == other.getExpiration() && (this.secret == null ? other.getKey() == null : other.getKey() != null && Bytes.equals((byte[])this.secret.getEncoded(), (byte[])other.getKey().getEncoded()));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("AuthenticationKey[").append("id=").append(this.id).append(", expiration=").append(Instant.ofEpochMilli(this.expirationDate)).append(", obj=").append(super.toString()).append("]");
        return buf.toString();
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.id);
        WritableUtils.writeVLong((DataOutput)out, (long)this.expirationDate);
        if (this.secret == null) {
            WritableUtils.writeVInt((DataOutput)out, (int)-1);
        } else {
            byte[] keyBytes = this.secret.getEncoded();
            WritableUtils.writeVInt((DataOutput)out, (int)keyBytes.length);
            out.write(keyBytes);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.id = WritableUtils.readVInt((DataInput)in);
        this.expirationDate = WritableUtils.readVLong((DataInput)in);
        int keyLength = WritableUtils.readVInt((DataInput)in);
        if (keyLength < 0) {
            this.secret = null;
        } else {
            byte[] keyBytes = new byte[keyLength];
            in.readFully(keyBytes);
            this.secret = AuthenticationTokenSecretManager.createSecretKey(keyBytes);
        }
    }
}

