/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class CellSerialization
implements Serialization<Cell> {
    public boolean accept(Class<?> c) {
        return Cell.class.isAssignableFrom(c);
    }

    public CellDeserializer getDeserializer(Class<Cell> t) {
        return new CellDeserializer();
    }

    public CellSerializer getSerializer(Class<Cell> c) {
        return new CellSerializer();
    }

    public static class CellSerializer
    implements Serializer<Cell> {
        private DataOutputStream dos;

        public void close() throws IOException {
            this.dos.close();
        }

        public void open(OutputStream os) throws IOException {
            this.dos = new DataOutputStream(os);
        }

        public void serialize(Cell kv) throws IOException {
            this.dos.writeInt(PrivateCellUtil.estimatedSerializedSizeOf((Cell)kv) - 4);
            PrivateCellUtil.writeCell((Cell)kv, (OutputStream)this.dos, (boolean)true);
        }
    }

    public static class CellDeserializer
    implements Deserializer<Cell> {
        private DataInputStream dis;

        public void close() throws IOException {
            this.dis.close();
        }

        public KeyValue deserialize(Cell ignore) throws IOException {
            return KeyValueUtil.create((DataInput)this.dis);
        }

        public void open(InputStream is) throws IOException {
            this.dis = new DataInputStream(is);
        }
    }
}

