/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.ClosableIterator;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.SuspendingTServer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.hadoop.fs.Path;

public class MetaDataStateStore
extends TabletStateStore {
    private static final int THREADS = 4;
    private static final int LATENCY = 1000;
    private static final int MAX_MEMORY = 0xC800000;
    protected final ClientContext context;
    protected final CurrentState state;
    private final String targetTableName;

    protected MetaDataStateStore(ClientContext context, CurrentState state, String targetTableName) {
        this.context = context;
        this.state = state;
        this.targetTableName = targetTableName;
    }

    public MetaDataStateStore(ClientContext context, CurrentState state) {
        this(context, state, "accumulo.metadata");
    }

    protected MetaDataStateStore(AccumuloServerContext context, String tableName) {
        this(context, null, tableName);
    }

    public MetaDataStateStore(AccumuloServerContext context) {
        this(context, "accumulo.metadata");
    }

    @Override
    public ClosableIterator<TabletLocationState> iterator() {
        return new MetaDataTableScanner(this.context, MetadataSchema.TabletsSection.getRange(), this.state, this.targetTableName);
    }

    @Override
    public void setLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (Assignment assignment : assignments) {
                Mutation m = new Mutation(assignment.tablet.getMetadataEntry());
                assignment.server.putLocation(m);
                assignment.server.clearFutureLocation(m);
                SuspendingTServer.clearSuspension(m);
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    BatchWriter createBatchWriter() {
        try {
            return this.context.getConnector().createBatchWriter(this.targetTableName, new BatchWriterConfig().setMaxMemory(0xC800000L).setMaxLatency(1000L, TimeUnit.MILLISECONDS).setMaxWriteThreads(4));
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setFutureLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (Assignment assignment : assignments) {
                Mutation m = new Mutation(assignment.tablet.getMetadataEntry());
                SuspendingTServer.clearSuspension(m);
                assignment.server.putFutureLocation(m);
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void unassign(Collection<TabletLocationState> tablets, Map<TServerInstance, List<Path>> logsForDeadServers) throws DistributedStoreException {
        this.suspend(tablets, logsForDeadServers, -1L);
    }

    @Override
    public void suspend(Collection<TabletLocationState> tablets, Map<TServerInstance, List<Path>> logsForDeadServers, long suspensionTimestamp) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (TabletLocationState tls : tablets) {
                Mutation m = new Mutation(tls.extent.getMetadataEntry());
                if (tls.current != null) {
                    List<Path> logs;
                    tls.current.clearLocation(m);
                    if (logsForDeadServers != null && (logs = logsForDeadServers.get(tls.current)) != null) {
                        for (Path log : logs) {
                            LogEntry entry = new LogEntry(tls.extent, 0L, tls.current.hostPort(), log.toString());
                            m.put(entry.getColumnFamily(), entry.getColumnQualifier(), entry.getValue());
                        }
                    }
                    if (suspensionTimestamp >= 0L) {
                        SuspendingTServer suspender = new SuspendingTServer(tls.current.getLocation(), suspensionTimestamp);
                        suspender.setSuspension(m);
                    }
                }
                if (tls.suspend != null && suspensionTimestamp < 0L) {
                    SuspendingTServer.clearSuspension(m);
                }
                if (tls.future != null) {
                    tls.future.clearFutureLocation(m);
                }
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void unsuspend(Collection<TabletLocationState> tablets) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (TabletLocationState tls : tablets) {
                if (tls.suspend != null) continue;
                Mutation m = new Mutation(tls.extent.getMetadataEntry());
                SuspendingTServer.clearSuspension(m);
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    @Override
    public String name() {
        return "Normal Tablets";
    }
}

