/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.replication;

import com.google.protobuf.GeneratedMessage;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaSystemHelper {
    private static final Logger log = LoggerFactory.getLogger(ReplicaSystemHelper.class);
    private ClientContext context;

    public ReplicaSystemHelper(ClientContext context) {
        Objects.requireNonNull(context);
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordNewStatus(Path filePath, Replication.Status status, ReplicationTarget target) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try (BatchWriter bw = this.context.getConnector().createBatchWriter("accumulo.replication", new BatchWriterConfig());){
            log.debug("Recording new status for {}, {}", (Object)filePath.toString(), (Object)ProtobufUtil.toString((GeneratedMessage)status));
            Mutation m = new Mutation((CharSequence)filePath.toString());
            ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)ProtobufUtil.toValue((GeneratedMessage)status));
            bw.addMutation(m);
        }
    }
}

