/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.net.util.Base64;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.registry.client.api.DNSOperations;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.dns.ApplicationServiceRecordProcessor;
import org.apache.hadoop.registry.server.dns.BaseServiceRecordProcessor;
import org.apache.hadoop.registry.server.dns.ContainerServiceRecordProcessor;
import org.apache.hadoop.registry.server.dns.LookupTask;
import org.apache.hadoop.registry.server.dns.RecordCreatorFactory;
import org.apache.hadoop.registry.server.dns.ReverseZoneUtils;
import org.apache.hadoop.registry.server.dns.SecureableZone;
import org.apache.hadoop.registry.server.dns.ZoneSelector;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.DSRecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Header;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;
import org.xbill.DNS.Zone;

public class RegistryDNS
extends AbstractService
implements DNSOperations,
ZoneSelector {
    public static final String CONTAINER = "container";
    static final int FLAG_DNSSECOK = 1;
    static final int FLAG_SIGONLY = 2;
    private static final Logger LOG = LoggerFactory.getLogger(RegistryDNS.class);
    public static final String IN_ADDR_ARPA = "in-addr.arpa.";
    public static final String ZONE_SUFFIX = ".zone";
    private ExecutorService executor;
    private ReentrantReadWriteLock zoneLock = new ReentrantReadWriteLock();
    private CloseableLock readLock = new CloseableLock(this.zoneLock.readLock());
    private CloseableLock writeLock = new CloseableLock(this.zoneLock.writeLock());
    private String domainName;
    private long ttl = 0L;
    private static final Pattern USER_NAME = Pattern.compile("/users/(\\w*)/?");
    private Boolean dnssecEnabled;
    private PrivateKey privateKey;
    private ConcurrentMap<Name, DNSKEYRecord> dnsKeyRecs = new ConcurrentHashMap<Name, DNSKEYRecord>();
    private ConcurrentMap<Name, Zone> zones = new ConcurrentHashMap<Name, Zone>();
    private Name bindHost;
    private boolean channelsInitialized = false;
    private final Object resolverUpdateLock = new Object();
    private boolean resolverUpdateRequested = true;
    private final RegistryCommand addRecordCommand = new RegistryCommand(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void exec(Zone zone, Record record) throws IOException {
            if (zone != null) {
                try (CloseableLock lock = RegistryDNS.this.writeLock.lock();){
                    zone.addRecord(record);
                    LOG.info("Registered {}", (Object)record);
                    if (!RegistryDNS.this.isDNSSECEnabled()) return;
                    Calendar cal = Calendar.getInstance();
                    Date inception = cal.getTime();
                    cal.add(1, 1);
                    Date expiration = cal.getTime();
                    RRset rRset = zone.findExactMatch(record.getName(), record.getType());
                    try {
                        DNSKEYRecord dnskeyRecord = (DNSKEYRecord)RegistryDNS.this.dnsKeyRecs.get(zone.getOrigin());
                        RRSIGRecord rrsigRecord = DNSSEC.sign((RRset)rRset, (DNSKEYRecord)dnskeyRecord, (PrivateKey)RegistryDNS.this.privateKey, (Date)inception, (Date)expiration);
                        LOG.info("Adding {}", (Object)rrsigRecord);
                        rRset.addRR((Record)rrsigRecord);
                        return;
                    }
                    catch (DNSSEC.DNSSECException e) {
                        throw new IOException(e);
                    }
                }
            } else {
                LOG.warn("Unable to find zone matching record {}", (Object)record);
            }
        }

        private void addDSRecord(Zone zone, Name name, int dClass, long dsTtl, Date inception, Date expiration) throws DNSSEC.DNSSECException {
            DNSKEYRecord dnskeyRecord = (DNSKEYRecord)RegistryDNS.this.dnsKeyRecs.get(zone.getOrigin());
            DSRecord dsRecord = new DSRecord(name, dClass, dsTtl, 1, dnskeyRecord);
            zone.addRecord((Record)dsRecord);
            LOG.info("Adding {}", (Object)dsRecord);
            RRset rRset = zone.findExactMatch(dsRecord.getName(), dsRecord.getType());
            RRSIGRecord rrsigRecord = DNSSEC.sign((RRset)rRset, (DNSKEYRecord)dnskeyRecord, (PrivateKey)RegistryDNS.this.privateKey, (Date)inception, (Date)expiration);
            rRset.addRR((Record)rrsigRecord);
        }

        @Override
        public String getLogDescription() {
            return "Registering ";
        }
    };
    private final RegistryCommand removeRecordCommand = new RegistryCommand(){

        @Override
        public void exec(Zone zone, Record record) throws IOException {
            RRset rRset;
            if (zone == null) {
                LOG.error("Unable to remove record because zone is null: {}", (Object)record);
                return;
            }
            zone.removeRecord(record);
            LOG.info("Removed {}", (Object)record);
            if (RegistryDNS.this.isDNSSECEnabled() && (rRset = zone.findExactMatch(record.getName(), 43)) != null) {
                zone.removeRecord(rRset.first());
            }
        }

        @Override
        public String getLogDescription() {
            return "Deleting ";
        }
    };

    public RegistryDNS(String name) {
        super(name);
        this.executor = HadoopExecutors.newCachedThreadPool((ThreadFactory)new ThreadFactory(){
            private AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "RegistryDNS " + this.counter.getAndIncrement());
            }
        });
    }

    public void initializeChannels(Configuration conf) throws Exception {
        if (this.channelsInitialized) {
            return;
        }
        this.channelsInitialized = true;
        int port = conf.getInt("hadoop.registry.dns.bind-port", 5335);
        InetAddress addr = InetAddress.getLocalHost();
        String bindAddress = conf.get("hadoop.registry.dns.bind-address");
        if (bindAddress != null) {
            addr = InetAddress.getByName(bindAddress);
        }
        LOG.info("Opening TCP and UDP channels on {} port {}", (Object)addr, (Object)port);
        this.addNIOUDP(addr, port);
        this.addNIOTCP(addr, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDNSServer(Configuration conf) {
        Object object = this.resolverUpdateLock;
        synchronized (object) {
            ExtendedResolver resolver;
            if (!this.resolverUpdateRequested) {
                return;
            }
            int port = conf.getInt("hadoop.registry.dns.bind-port", 5335);
            this.resolverUpdateRequested = false;
            ArrayList<InetAddress> list = new ArrayList<InetAddress>();
            try {
                if (port != 53) {
                    throw new SocketException("Bypass filtering local DNS server.");
                }
                Enumeration<NetworkInterface> net = NetworkInterface.getNetworkInterfaces();
                while (net.hasMoreElements()) {
                    NetworkInterface networkInterface = net.nextElement();
                    Enumeration<InetAddress> ee = networkInterface.getInetAddresses();
                    while (ee.hasMoreElements()) {
                        InetAddress i = ee.nextElement();
                        list.add(i);
                    }
                }
            }
            catch (SocketException net) {
                // empty catch block
            }
            ResolverConfig.refresh();
            try {
                resolver = new ExtendedResolver();
            }
            catch (UnknownHostException unknownHostException) {
                LOG.error("Can not resolve DNS servers: ", (Throwable)unknownHostException);
                return;
            }
            for (Resolver check : resolver.getResolvers()) {
                if (check instanceof SimpleResolver) {
                    InetAddress address = ((SimpleResolver)check).getAddress().getAddress();
                    if (list.contains(address)) {
                        resolver.deleteResolver(check);
                        continue;
                    }
                    check.setTimeout(30);
                    continue;
                }
                LOG.error("Not simple resolver!!!?" + check);
            }
            Class<Lookup> clazz = Lookup.class;
            synchronized (Lookup.class) {
                Lookup.setDefaultResolver((Resolver)resolver);
                Lookup.setDefaultSearchPath((Name[])ResolverConfig.getCurrentConfig().searchPath());
                // ** MonitorExit[var6_10] (shouldn't be in output)
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("DNS servers: ");
                if (ResolverConfig.getCurrentConfig().servers() != null) {
                    for (String server : ResolverConfig.getCurrentConfig().servers()) {
                        stringBuilder.append(server);
                        stringBuilder.append(" ");
                    }
                }
                LOG.info(stringBuilder.toString());
            }
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        try {
            this.updateDNSServer(conf);
            this.setDomainName(conf);
            this.initializeZones(conf);
            this.initializeChannels(conf);
        }
        catch (IOException e) {
            LOG.error("Error initializing Registry DNS Server", (Throwable)e);
            throw e;
        }
    }

    void initializeZones(Configuration conf) throws IOException {
        this.ttl = conf.getTimeDuration("hadoop.registry.dns.dns-ttl", 1L, TimeUnit.SECONDS);
        RecordCreatorFactory.setTtl(this.ttl);
        this.setDNSSECEnabled(conf);
        this.initializeZonesFromFiles(conf);
        Zone registryZone = this.configureZone(Name.fromString((String)this.domainName), conf);
        this.zones.put(registryZone.getOrigin(), registryZone);
        this.initializeReverseLookupZone(conf);
        StringBuilder builder = new StringBuilder();
        builder.append("DNS zones: ").append(System.lineSeparator());
        for (Map.Entry entry : this.zones.entrySet()) {
            builder.append(System.lineSeparator()).append(entry.getValue());
        }
        LOG.info(builder.toString());
    }

    private void signZones() throws IOException {
        if (this.isDNSSECEnabled()) {
            Collection zoneCollection = this.zones.values();
            for (Zone zone : zoneCollection) {
                for (RRset rRset : zone) {
                    Iterator sigs = rRset.sigs();
                    if (sigs.hasNext()) continue;
                    try {
                        this.signSiteRecord(zone, rRset.first());
                    }
                    catch (DNSSEC.DNSSECException e) {
                        throw new IOException(e);
                    }
                }
            }
        }
    }

    private void initializeZonesFromFiles(Configuration conf) throws IOException {
        String zonesDir = conf.get("hadoop.registry.dns.zones-dir");
        if (zonesDir != null) {
            Iterator iterator = FileUtils.iterateFiles((File)new File(zonesDir), (IOFileFilter)new IOFileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith(RegistryDNS.ZONE_SUFFIX);
                }

                public boolean accept(File file, String s) {
                    return s.endsWith(RegistryDNS.ZONE_SUFFIX);
                }
            }, null);
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                String name = file.getName();
                name = name.substring(0, name.indexOf(ZONE_SUFFIX) + 1);
                SecureableZone zone = new SecureableZone(Name.fromString((String)name), file.getAbsolutePath());
                this.zones.putIfAbsent(zone.getOrigin(), zone);
            }
        }
    }

    @VisibleForTesting
    protected int getZoneCount() {
        return this.zones.size();
    }

    private void initializeReverseLookupZone(Configuration conf) throws IOException {
        Boolean shouldSplitReverseZone = conf.getBoolean("hadoop.registry.dns.split-reverse-zone", false);
        if (shouldSplitReverseZone.booleanValue()) {
            long subnetCount = ReverseZoneUtils.getSubnetCountForReverseZones(conf);
            this.addSplitReverseZones(conf, subnetCount);
        } else {
            Name reverseLookupZoneName = this.getReverseZoneName(conf);
            if (reverseLookupZoneName == null) {
                return;
            }
            Zone reverseLookupZone = this.configureZone(reverseLookupZoneName, conf);
            this.zones.put(reverseLookupZone.getOrigin(), reverseLookupZone);
        }
    }

    @VisibleForTesting
    protected void addSplitReverseZones(Configuration conf, long subnetCount) throws IOException {
        String subnet = conf.get("hadoop.registry.dns.zone-subnet");
        String range = conf.get("hadoop.registry.dns.split-reverse-zone-range");
        int idx = 0;
        while ((long)idx < subnetCount) {
            Name reverseLookupZoneName = this.getReverseZoneName(ReverseZoneUtils.getReverseZoneNetworkAddress(subnet, Integer.parseInt(range), idx));
            Zone reverseLookupZone = this.configureZone(reverseLookupZoneName, conf);
            this.zones.put(reverseLookupZone.getOrigin(), reverseLookupZone);
            ++idx;
        }
    }

    protected Name getReverseZoneName(Configuration conf) {
        Name name = null;
        String zoneSubnet = this.getZoneSubnet(conf);
        if (zoneSubnet == null) {
            LOG.warn("Zone subnet is not configured.  Reverse lookups disabled");
        } else {
            String mask = conf.get("hadoop.registry.dns.zone-mask");
            if (mask != null) {
                SubnetUtils utils = new SubnetUtils(zoneSubnet, mask);
                name = this.getReverseZoneName(utils, zoneSubnet);
            } else {
                name = this.getReverseZoneName(zoneSubnet);
            }
        }
        return name;
    }

    private String getZoneSubnet(Configuration conf) {
        String[] bytes;
        String subnet = conf.get("hadoop.registry.dns.zone-subnet");
        if (subnet != null && (bytes = subnet.split("\\.")).length == 3) {
            subnet = subnet + ".0";
        }
        return subnet;
    }

    private Name getReverseZoneName(String networkAddress) {
        return this.getReverseZoneName(null, networkAddress);
    }

    private Name getReverseZoneName(SubnetUtils utils, String networkAddress) {
        String[] bytes;
        Name reverseZoneName = null;
        boolean isLargeNetwork = false;
        if (utils != null) {
            boolean bl = isLargeNetwork = utils.getInfo().getAddressCountLong() > 256L;
        }
        if ((bytes = networkAddress.split("\\.")).length == 4) {
            String reverseLookupZoneName = null;
            reverseLookupZoneName = isLargeNetwork ? String.format("%s.%s.%s", bytes[1], bytes[0], IN_ADDR_ARPA) : String.format("%s.%s.%s.%s", bytes[2], bytes[1], bytes[0], IN_ADDR_ARPA);
            try {
                reverseZoneName = Name.fromString((String)reverseLookupZoneName);
            }
            catch (TextParseException e) {
                LOG.warn("Unable to convert {} to DNS name", (Object)reverseLookupZoneName);
            }
        }
        return reverseZoneName;
    }

    private Zone configureZone(Name zoneName, Configuration conf) throws IOException {
        this.bindHost = Name.fromString((String)(InetAddress.getLocalHost().getCanonicalHostName() + "."));
        SOARecord soaRecord = new SOARecord(zoneName, 1, this.ttl, this.bindHost, this.bindHost, this.getSerial(), 86000L, 7200L, 1209600L, 600L);
        NSRecord nsRecord = new NSRecord(zoneName, 1, this.ttl, this.bindHost);
        Zone zone = (Zone)this.zones.get(zoneName);
        if (zone == null) {
            zone = new SecureableZone(zoneName, new Record[]{soaRecord, nsRecord});
        }
        try {
            this.enableDNSSECIfNecessary(zone, conf, soaRecord, nsRecord);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException(e);
        }
        catch (DNSSEC.DNSSECException e) {
            throw new IOException(e);
        }
        return zone;
    }

    private long getSerial() {
        Date curDate = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHH");
        String serial = simpleDateFormat.format(curDate);
        return Long.parseLong(serial);
    }

    @VisibleForTesting
    protected void setDNSSECEnabled(Configuration conf) {
        this.dnssecEnabled = conf.getBoolean("hadoop.registry.dns.dnssec.enabled", false);
    }

    private boolean isDNSSECEnabled() {
        return this.dnssecEnabled;
    }

    private void enableDNSSECIfNecessary(Zone zone, Configuration conf, SOARecord soaRecord, NSRecord nsRecord) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, DNSSEC.DNSSECException {
        if (this.isDNSSECEnabled()) {
            String publicKey = conf.get("hadoop.registry.dns.public-key");
            if (publicKey == null) {
                throw new IOException("DNSSEC Key not configured");
            }
            Name zoneName = zone.getOrigin();
            DNSKEYRecord dnskeyRecord = (DNSKEYRecord)this.dnsKeyRecs.get(zoneName);
            if (dnskeyRecord == null) {
                byte[] key = Base64.decodeBase64((byte[])publicKey.getBytes("UTF-8"));
                dnskeyRecord = new DNSKEYRecord(zoneName, 1, this.ttl, 256, 3, 8, key);
                this.dnsKeyRecs.putIfAbsent(zoneName, dnskeyRecord);
            }
            LOG.info("Registering {}", (Object)dnskeyRecord);
            try (CloseableLock lock = this.writeLock.lock();){
                zone.addRecord((Record)dnskeyRecord);
                String privateKeyFile = conf.get("hadoop.registry.dns.private-key-file", "/etc/hadoop/conf/registryDNS.private");
                Properties props = new Properties();
                try (FileInputStream inputStream = new FileInputStream(privateKeyFile);){
                    props.load(inputStream);
                }
                String privateModulus = props.getProperty("Modulus");
                String privateExponent = props.getProperty("PrivateExponent");
                RSAPrivateKeySpec privateSpec = new RSAPrivateKeySpec(new BigInteger(1, Base64.decodeBase64((String)privateModulus)), new BigInteger(1, Base64.decodeBase64((String)privateExponent)));
                KeyFactory factory = KeyFactory.getInstance("RSA");
                this.privateKey = factory.generatePrivate(privateSpec);
                this.signSiteRecord(zone, (Record)dnskeyRecord);
                this.signSiteRecord(zone, (Record)soaRecord);
                this.signSiteRecord(zone, (Record)nsRecord);
            }
        }
    }

    private void signSiteRecord(Zone zone, Record record) throws DNSSEC.DNSSECException {
        RRset rrset = zone.findExactMatch(record.getName(), record.getType());
        Calendar cal = Calendar.getInstance();
        Date inception = cal.getTime();
        cal.add(1, 1);
        Date expiration = cal.getTime();
        RRSIGRecord rrsigRecord = DNSSEC.sign((RRset)rrset, (DNSKEYRecord)((DNSKEYRecord)this.dnsKeyRecs.get(zone.getOrigin())), (PrivateKey)this.privateKey, (Date)inception, (Date)expiration);
        LOG.info("Adding {}", (Object)record);
        rrset.addRR((Record)rrsigRecord);
    }

    void setDomainName(Configuration conf) throws IOException {
        this.domainName = conf.get("hadoop.registry.dns.domain-name");
        if (this.domainName == null) {
            throw new IOException("No DNS domain name specified");
        }
        if (!this.domainName.endsWith(".")) {
            this.domainName = this.domainName + ".";
        }
    }

    protected void serviceStop() throws Exception {
        this.stopExecutor();
        super.serviceStop();
    }

    protected synchronized void stopExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public byte[] formErrorMessage(byte[] in) {
        Header header;
        try {
            header = new Header(in);
        }
        catch (IOException e) {
            return null;
        }
        return this.buildErrorMessage(header, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nioTCPClient(SocketChannel ch) throws IOException {
        try {
            byte[] response;
            ByteBuffer buf = ByteBuffer.allocate(1024);
            ch.read(buf);
            buf.flip();
            int messageLength = this.getMessgeLength(buf);
            byte[] in = new byte[messageLength];
            buf.get(in, 0, messageLength);
            try {
                Message query = new Message(in);
                LOG.info("received TCP query {}", (Object)query.getQuestion());
                response = this.generateReply(query, ch.socket());
                if (response == null) {
                    return;
                }
            }
            catch (IOException e) {
                response = this.formErrorMessage(in);
            }
            ByteBuffer out = ByteBuffer.allocate(response.length + 2);
            out.clear();
            byte[] data = new byte[2];
            data[1] = (byte)(response.length & 0xFF);
            data[0] = (byte)(response.length >> 8 & 0xFF);
            out.put(data);
            out.put(response);
            out.flip();
            while (out.hasRemaining()) {
                ch.write(out);
            }
        }
        catch (IOException e) {
            throw NetUtils.wrapException((String)ch.socket().getInetAddress().getHostName(), (int)ch.socket().getPort(), (String)ch.socket().getLocalAddress().getHostName(), (int)ch.socket().getLocalPort(), (IOException)e);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        finally {
            IOUtils.closeStream((Closeable)ch);
        }
    }

    private int getMessgeLength(ByteBuffer buf) throws EOFException {
        byte ch2;
        byte ch1 = buf.get();
        if ((ch1 | (ch2 = buf.get())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 & 0xFF);
    }

    public void serveNIOTCP(ServerSocketChannel serverSocketChannel, InetAddress addr, int port) throws Exception {
        try {
            while (true) {
                SocketChannel socketChannel;
                if ((socketChannel = serverSocketChannel.accept()) != null) {
                    this.executor.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            RegistryDNS.this.nioTCPClient(socketChannel);
                            return true;
                        }
                    });
                    continue;
                }
                Thread.sleep(500L);
            }
        }
        catch (IOException e) {
            throw NetUtils.wrapException((String)addr.getHostName(), (int)port, (String)addr.getHostName(), (int)port, (IOException)e);
        }
    }

    private ServerSocketChannel openTCPChannel(InetAddress addr, int port) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        try {
            serverSocketChannel.socket().bind(new InetSocketAddress(addr, port));
            serverSocketChannel.configureBlocking(false);
        }
        catch (IOException e) {
            throw NetUtils.wrapException(null, (int)0, (String)InetAddress.getLocalHost().getHostName(), (int)port, (IOException)e);
        }
        return serverSocketChannel;
    }

    public void addNIOTCP(final InetAddress addr, final int port) throws Exception {
        final ServerSocketChannel tcpChannel = this.openTCPChannel(addr, port);
        this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    RegistryDNS.this.serveNIOTCP(tcpChannel, addr, port);
                }
                catch (Exception e) {
                    LOG.error("Error initializing DNS TCP listener", (Throwable)e);
                    throw e;
                }
                return true;
            }
        });
    }

    public void addNIOUDP(final InetAddress addr, final int port) throws Exception {
        final DatagramChannel udpChannel = this.openUDPChannel(addr, port);
        this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    RegistryDNS.this.serveNIOUDP(udpChannel, addr, port);
                }
                catch (Exception e) {
                    LOG.error("Error initializing DNS UDP listener", (Throwable)e);
                    throw e;
                }
                return true;
            }
        });
    }

    private synchronized void serveNIOUDP(DatagramChannel channel, InetAddress addr, int port) throws Exception {
        SocketAddress remoteAddress = null;
        try {
            ByteBuffer input = ByteBuffer.allocate(4096);
            ByteBuffer output = ByteBuffer.allocate(4096);
            byte[] in = null;
            while (true) {
                input.clear();
                try {
                    remoteAddress = channel.receive(input);
                }
                catch (IOException e) {
                    LOG.debug("Error during message receipt", (Throwable)e);
                    continue;
                }
                byte[] response = null;
                try {
                    int position = input.position();
                    in = new byte[position];
                    input.flip();
                    input.get(in);
                    Message query = new Message(in);
                    LOG.info("{}: received UDP query {}", (Object)remoteAddress, (Object)query.getQuestion());
                    response = this.generateReply(query, null);
                    if (response == null) {
                        continue;
                    }
                }
                catch (IOException e) {
                    response = this.formErrorMessage(in);
                }
                output.clear();
                output.put(response);
                output.flip();
                LOG.debug("{}:  sending response", (Object)remoteAddress);
                channel.send(output, remoteAddress);
            }
        }
        catch (Exception e) {
            if (e instanceof IOException && remoteAddress != null) {
                throw NetUtils.wrapException((String)addr.getHostName(), (int)port, (String)((InetSocketAddress)remoteAddress).getHostName(), (int)((InetSocketAddress)remoteAddress).getPort(), (IOException)((IOException)e));
            }
            throw e;
        }
    }

    private DatagramChannel openUDPChannel(InetAddress addr, int port) throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        try {
            channel.socket().bind(new InetSocketAddress(addr, port));
        }
        catch (IOException e) {
            throw NetUtils.wrapException(null, (int)0, (String)InetAddress.getLocalHost().getHostName(), (int)port, (IOException)e);
        }
        return channel;
    }

    byte[] buildErrorMessage(Header header, int rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        for (int i = 0; i < 4; ++i) {
            response.removeAllRecords(i);
        }
        response.addRecord(question, 0);
        header.setRcode(rcode);
        return response.toWire();
    }

    public byte[] errorMessage(Message query, int rcode) {
        return this.buildErrorMessage(query.getHeader(), rcode, query.getQuestion());
    }

    byte[] generateReply(Message query, Socket s) throws IOException {
        int flags = 0;
        OPTRecord queryOPT = query.getOPT();
        int maxLength = this.getMaxLength(s, queryOPT);
        Header header = query.getHeader();
        if (header.getFlag(0)) {
            LOG.debug("returning null");
            return null;
        }
        if (header.getRcode() != 0) {
            return this.errorMessage(query, 1);
        }
        if (header.getOpcode() != 0) {
            return this.errorMessage(query, 4);
        }
        Record queryRecord = query.getQuestion();
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = 1;
        }
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(0);
        if (query.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
            response.getHeader().setFlag(8);
        }
        response.addRecord(queryRecord, 0);
        Name name = queryRecord.getName();
        int type = queryRecord.getType();
        int dclass = queryRecord.getDClass();
        TSIGRecord queryTSIG = query.getTSIG();
        if (type == 252 && s != null) {
            return this.doAXFR(name, query, null, queryTSIG, s);
        }
        if (!Type.isRR((int)type) && type != 255) {
            return this.errorMessage(query, 4);
        }
        LOG.debug("calling addAnswer");
        byte rcode = this.addAnswer(response, name, type, dclass, 0, flags);
        if (rcode != 0) {
            rcode = this.remoteLookup(response, name, type, 0);
            response.getHeader().setRcode((int)rcode);
        }
        this.addAdditional(response, flags);
        if (queryOPT != null) {
            int optflags = flags == 1 ? 32768 : 0;
            OPTRecord opt = new OPTRecord(4096, rcode >>> 16, 0, optflags);
            response.addRecord((Record)opt, 3);
        }
        return response.toWire(maxLength);
    }

    private byte remoteLookup(Message response, Name name, int type, int iterations) {
        Record[] cnameAnswers;
        if (name.toString().equals(".")) {
            type = 2;
        }
        if (type != 5 && (cnameAnswers = this.getRecords(name, 5)) != null) {
            for (Record cnameR : cnameAnswers) {
                if (response.findRecord(cnameR)) continue;
                response.addRecord(cnameR, 1);
            }
        }
        Record[] answers = this.getRecords(name, type);
        try {
            for (Record r : answers) {
                if (!response.findRecord(r)) {
                    if (r.getType() == 6) {
                        response.addRecord(r, 2);
                    } else {
                        response.addRecord(r, 1);
                    }
                }
                if (r.getType() != 5) continue;
                Name cname = ((CNAMERecord)r).getAlias();
                if (iterations >= 6) continue;
                this.remoteLookup(response, cname, type, iterations + 1);
            }
        }
        catch (NullPointerException e) {
            return 3;
        }
        catch (Throwable e) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Record[] getRecords(Name name, int type) {
        Record[] result = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Record[]> future = executor.submit(new LookupTask(name, type));
        try {
            Record[] recordArray = result = future.get(1500L, TimeUnit.MILLISECONDS);
            return recordArray;
        }
        catch (ExceptionInInitializerError | InterruptedException | NullPointerException | ExecutionException | TimeoutException e) {
            LOG.warn("Failed to lookup: {} type: {}", new Object[]{name, Type.string((int)type), e});
            Record[] recordArray = result;
            return recordArray;
        }
        finally {
            executor.shutdown();
        }
    }

    private Message createPrimaryQuery(Message query) throws NameTooLongException, TextParseException {
        Name name = query.getQuestion().getName();
        if (name.labels() > 0 && name.labels() <= 2) {
            int id = query.getHeader().getID();
            String queryName = name.getLabelString(0);
            Name qualifiedName = Name.concatenate((Name)Name.fromString((String)queryName), (Name)Name.fromString((String)this.domainName));
            LOG.info("Received query {}.  Forwarding query {}", (Object)name, (Object)qualifiedName);
            Record question = Record.newRecord((Name)qualifiedName, (int)query.getQuestion().getType(), (int)query.getQuestion().getDClass());
            query = Message.newQuery((Record)question);
            query.getHeader().setID(id);
        }
        return query;
    }

    private int getMaxLength(Socket s, OPTRecord queryOPT) {
        int maxLength = s != null ? 65535 : (queryOPT != null ? Math.max(queryOPT.getPayloadSize(), 512) : 512);
        return maxLength;
    }

    private void addAdditional2(Message response, int section, int flags) {
        Record[] records = response.getSectionArray(section);
        for (int i = 0; i < records.length; ++i) {
            Record r = records[i];
            Name glueName = r.getAdditionalName();
            if (glueName == null) continue;
            this.addGlue(response, glueName, flags);
        }
    }

    private void addAdditional(Message response, int flags) {
        this.addAdditional2(response, 1, flags);
        this.addAdditional2(response, 2, flags);
    }

    private void addGlue(Message response, Name name, int flags) {
        RRset a = this.findExactMatch(name, 1);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, 3, flags);
    }

    public RRset findExactMatch(Name name, int type) {
        try (CloseableLock lock = this.readLock.lock();){
            Zone zone = this.findBestZone(name);
            if (zone != null) {
                RRset rRset = zone.findExactMatch(name, type);
                return rRset;
            }
        }
        return null;
    }

    @Override
    public Zone findBestZone(Name name) {
        Zone foundzone = null;
        foundzone = (Zone)this.zones.get(name);
        if (foundzone != null) {
            return foundzone;
        }
        int labels = name.labels();
        for (int i = 1; i < labels; ++i) {
            Name tname = new Name(name, i);
            foundzone = (Zone)this.zones.get(tname);
            if (foundzone == null) continue;
            return foundzone;
        }
        return null;
    }

    byte addAnswer(Message response, Name name, int type, int dclass, int iterations, int flags) {
        SetResponse sr = null;
        int rcode = 0;
        if (iterations > 6) {
            return 0;
        }
        if (type == 24 || type == 46) {
            type = 255;
            flags |= 2;
        }
        Zone zone = this.findBestZone(name);
        LOG.debug("finding record");
        try (CloseableLock lock = this.readLock.lock();){
            if (zone != null) {
                sr = zone.findRecords(name, type);
            } else {
                rcode = 9;
            }
        }
        LOG.info("found local record? {}", (Object)(sr != null && sr.isSuccessful() ? 1 : 0));
        if (sr != null) {
            if (sr.isCNAME()) {
                CNAMERecord cname = sr.getCNAME();
                RRset rrset = zone.findExactMatch(cname.getName(), 5);
                this.addRRset(name, response, rrset, 1, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
                rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags);
            }
            if (sr.isNXDOMAIN()) {
                response.getHeader().setRcode(3);
                if (this.isDNSSECEnabled()) {
                    try {
                        this.addNXT(response, flags);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to add NXTRecord to AUTHORITY Section", (Throwable)e);
                    }
                }
                this.addSOA(response, zone, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
                rcode = 3;
            } else if (sr.isNXRRSET()) {
                LOG.info("No data found the given name {} and type {}", (Object)name, (Object)type);
                this.addSOA(response, zone, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            } else if (sr.isSuccessful()) {
                Object[] rrsets = sr.answers();
                LOG.info("found answers {}", rrsets);
                for (int i = 0; i < rrsets.length; ++i) {
                    this.addRRset(name, response, (RRset)rrsets[i], 1, flags);
                }
                this.addNS(response, zone, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
        } else if (zone != null) {
            Name defaultDomain = null;
            try {
                defaultDomain = Name.fromString((String)this.domainName);
                zone = (Zone)this.zones.get(defaultDomain);
                this.addNS(response, zone, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
            catch (TextParseException e) {
                LOG.warn("Unable to obtain default zone for unknown name response", (Throwable)e);
            }
        }
        return (byte)rcode;
    }

    private void addSOA(Message response, Zone zone, int flags) {
        RRset soa = zone.findExactMatch(zone.getOrigin(), 6);
        this.addRRset(soa.getName(), response, soa, 2, flags);
    }

    private void addNXT(Message response, int flags) throws DNSSEC.DNSSECException, IOException {
        Record nxtRecord = this.getNXTRecord(response.getSectionArray(0)[0]);
        Zone zone = this.findBestZone(nxtRecord.getName());
        this.addRecordCommand.exec(zone, nxtRecord);
        RRset nxtRR = zone.findExactMatch(nxtRecord.getName(), 30);
        this.addRRset(nxtRecord.getName(), response, nxtRR, 2, flags);
        this.removeRecordCommand.exec(zone, nxtRecord);
    }

    private Record getNXTRecord(Record query) {
        Record response = null;
        SecureableZone zone = (SecureableZone)this.findBestZone(query.getName());
        if (zone != null && (response = zone.getNXTRecord(query, zone)) == null) {
            response = zone.getSOA();
        }
        return response;
    }

    private void addNS(Message response, Zone zone, int flags) {
        RRset nsRecords = zone.getNS();
        this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
    }

    private void addRRset(Name name, Message response, RRset rrset, int section, int flags) {
        Record r;
        for (int s = 1; s <= section; ++s) {
            if (!response.findRRset(name, rrset.getType(), s)) continue;
            return;
        }
        if ((flags & 2) == 0) {
            Iterator it = rrset.rrs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
        if ((flags & 3) != 0) {
            Iterator it = rrset.sigs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
    }

    byte[] doAXFR(Name name, Message query, TSIG tsig, TSIGRecord qtsig, Socket s) {
        boolean first = true;
        Zone zone = this.findBestZone(name);
        if (zone == null) {
            return this.errorMessage(query, 5);
        }
        Iterator it = zone.AXFR();
        try {
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            int id = query.getHeader().getID();
            while (it.hasNext()) {
                RRset rrset = (RRset)it.next();
                Message response = new Message(id);
                Header header = response.getHeader();
                header.setFlag(0);
                header.setFlag(5);
                this.addRRset(rrset.getName(), response, rrset, 1, 1);
                if (tsig != null) {
                    tsig.applyStream(response, qtsig, first);
                    qtsig = response.getTSIG();
                }
                first = false;
                byte[] out = response.toWire();
                dataOut.writeShort(out.length);
                dataOut.write(out);
            }
        }
        catch (IOException ex) {
            System.out.println("AXFR failed");
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void op(String path, ServiceRecord record, RegistryCommand command) throws IOException {
        try {
            String yarnPersistanceValue = record.get("yarn:persistence");
            if (yarnPersistanceValue != null) {
                BaseServiceRecordProcessor processor;
                if (yarnPersistanceValue.equals(CONTAINER)) {
                    processor = new ContainerServiceRecordProcessor(record, path, this.domainName, this);
                } else {
                    LOG.debug("Creating ApplicationServiceRecordProcessor for {}", (Object)yarnPersistanceValue);
                    processor = new ApplicationServiceRecordProcessor(record, path, this.domainName, this);
                }
                processor.manageDNSRecords(command);
            } else {
                LOG.warn("Yarn Registry record {} does not contain {} attribute ", (Object)record.toString(), (Object)"yarn:persistence");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String getUsername(String path) {
        String user = "anonymous";
        Matcher matcher = USER_NAME.matcher(path);
        if (matcher.find()) {
            user = matcher.group(1);
        }
        return user;
    }

    @Override
    public void register(String path, ServiceRecord record) throws IOException {
        this.op(path, record, this.addRecordCommand);
    }

    @Override
    public void delete(String path, ServiceRecord record) throws IOException {
        this.op(path, record, this.removeRecordCommand);
    }

    public static class CloseableLock
    implements AutoCloseable {
        private Lock lock;

        public CloseableLock(Lock lock) {
            this.lock = lock;
        }

        public CloseableLock lock() {
            this.lock.lock();
            return this;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }

    static interface RegistryCommand {
        public void exec(Zone var1, Record var2) throws IOException;

        public String getLogDescription();
    }
}

