/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.swingui.AboutDialog;
import junit.swingui.ProgressBar;
import junit.swingui.TestBrowser;
import junit.swingui.TraceFrame;
import junit.util.StandardTestSuiteLoader;
import junit.util.StringUtil;
import junit.util.TestSuiteLoader;
import junit.util.Version;

public class TestRunner
implements TestListener,
DocumentListener {
    protected JFrame fFrame;
    private Thread fRunner;
    private TestResult fTestResult;
    private TestSuiteLoader fTestLoader;
    private TraceFrame fTraceFrame;
    private TestBrowser fTestBrowser;
    private JComboBox fSuiteCombo;
    private JButton fRun;
    private ProgressBar fProgressIndicator;
    private JList fFailureList;
    private DefaultListModel fFailures;
    private JLabel fLogo;
    private JTextField fNumberOfErrors;
    private JTextField fNumberOfFailures;
    private JTextField fNumberOfRuns;
    private JButton fQuitButton;
    private JButton fShowErrorButton;
    private JButton fRerunButton;
    private JTextField fStatusLine;
    private JPanel fPanel;
    private static Font PLAIN_FONT = new Font("dialog", 0, 12);
    private static Font BOLD_FONT = new Font("dialog", 1, 12);
    private static final int GAP = 4;
    private static final String SUITE_METHODNAME = "suite";
    static /* synthetic */ Class class$java$lang$String;

    private void about() {
        AboutDialog aboutDialog = new AboutDialog(this.fFrame);
        aboutDialog.setModal(true);
        ((Component)aboutDialog).setLocation(300, 300);
        aboutDialog.show();
    }

    static /* synthetic */ Thread access$22(TestRunner testRunner) {
        return testRunner.fRunner;
    }

    public void addError(Test test, Throwable throwable) {
        this.postError(test, throwable);
    }

    public void addFailure(Test test, Throwable throwable) {
        this.postFailure(test, throwable);
    }

    private void addGrid(JPanel jPanel, Component component, int n, int n2, int n3, int n4, double d, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.fill = n4;
        if (n4 == 1 || n4 == 3) {
            gridBagConstraints.weighty = 1.0;
        }
        gridBagConstraints.insets = new Insets(n2 == 0 ? 4 : 0, n == 0 ? 4 : 0, 4, 4);
        jPanel.add(component, gridBagConstraints);
    }

    private void addToHistory(String string) {
        int n = 0;
        while (n < this.fSuiteCombo.getItemCount()) {
            if (string.equals(this.fSuiteCombo.getItemAt(n))) {
                this.fSuiteCombo.removeItemAt(n);
                this.fSuiteCombo.insertItemAt(string, 0);
                this.fSuiteCombo.setSelectedIndex(0);
                return;
            }
            ++n;
        }
        this.fSuiteCombo.insertItemAt(string, 0);
        int n2 = this.fSuiteCombo.getItemCount() - 1;
        while (n2 > 5) {
            this.fSuiteCombo.removeItemAt(n2);
            --n2;
        }
    }

    private void appendFailure(String string, Test test, Throwable throwable) {
        this.fFailures.addElement(new TestFailure(test, throwable));
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void connectTestBrowser(Test test, boolean bl) {
        if (this.fTestBrowser != null && this.fTestBrowser.isVisible()) {
            if (bl) {
                this.fTestBrowser.showTestTree(test);
            }
            this.fTestResult.addListener(this.fTestBrowser.getTestListener());
        }
    }

    protected JPanel createCounterPanel() {
        this.fNumberOfErrors = this.createOutputField();
        this.fNumberOfFailures = this.createOutputField();
        this.fNumberOfRuns = this.createOutputField();
        JPanel jPanel = new JPanel(new GridLayout(2, 3));
        jPanel.add(new JLabel("Runs:"));
        jPanel.add(new JLabel("Errors:"));
        jPanel.add(new JLabel("Failures: "));
        jPanel.add(this.fNumberOfRuns);
        jPanel.add(this.fNumberOfErrors);
        jPanel.add(this.fNumberOfFailures);
        return jPanel;
    }

    protected JPanel createFailedPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 2));
        this.fShowErrorButton = new JButton("Show...");
        this.fShowErrorButton.setEnabled(false);
        this.fShowErrorButton.setToolTipText("Show the Stack Trace");
        this.fShowErrorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.showErrorTrace();
            }
        });
        this.fRerunButton = new JButton("Run");
        this.fRerunButton.setToolTipText("Run the Selected Test");
        this.fRerunButton.setEnabled(false);
        this.fRerunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.rerun();
            }
        });
        jPanel.add(this.fShowErrorButton);
        jPanel.add(this.fRerunButton);
        return jPanel;
    }

    protected JList createFailureList(ListModel listModel) {
        JList<Object> jList = new JList<Object>(listModel);
        jList.setFixedCellWidth(300);
        jList.setSelectionMode(0);
        jList.setCellRenderer(new FailureListCellRenderer());
        jList.setToolTipText("Failure - grey X; Error - red X");
        jList.setPreferredSize(new Dimension(200, 150));
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    TestRunner.this.showErrorTrace();
                }
            }
        });
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TestRunner.this.fShowErrorButton.setEnabled(TestRunner.this.isErrorSelected());
                TestRunner.this.fRerunButton.setEnabled(TestRunner.this.isErrorSelected());
            }
        });
        return jList;
    }

    protected JFrame createFrame(String string) {
        JFrame jFrame = new JFrame("Run Test Suite");
        Image image = this.loadFrameIcon();
        if (image != null) {
            ((Frame)jFrame).setIconImage(image);
        }
        jFrame.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)jFrame).setBackground(SystemColor.control);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TestRunner.this.terminate();
            }
        });
        return jFrame;
    }

    protected JMenu createJUnitMenu() {
        JMenu jMenu = new JMenu("JUnit");
        jMenu.setMnemonic('J');
        JMenuItem jMenuItem = new JMenuItem("About...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.about();
            }
        });
        jMenuItem.setMnemonic('A');
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Show Test Browser");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.showTestBrowser();
            }
        });
        jMenuItem2.setMnemonic('S');
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Exit");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.terminate();
            }
        });
        jMenuItem3.setMnemonic('x');
        jMenu.add(jMenuItem3);
        return jMenu;
    }

    protected JLabel createLogo() {
        URL uRL = this.getClass().getResource("logo.gif");
        return new JLabel(new ImageIcon(uRL));
    }

    protected void createMenus(JMenuBar jMenuBar) {
        jMenuBar.add(this.createJUnitMenu());
    }

    private JTextField createOutputField() {
        JTextField jTextField = new JTextField("0", 4);
        jTextField.setHorizontalAlignment(2);
        jTextField.setFont(BOLD_FONT);
        jTextField.setEditable(false);
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        return jTextField;
    }

    protected JButton createQuitButton() {
        JButton jButton = new JButton("Exit");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.terminate();
            }
        });
        return jButton;
    }

    protected JButton createRunButton() {
        JButton jButton = new JButton("Run");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.runSuite();
            }
        });
        return jButton;
    }

    protected Component createRunExtension() {
        return null;
    }

    protected JTextField createStatusLine() {
        JTextField jTextField = new JTextField();
        jTextField.setFont(BOLD_FONT);
        jTextField.setEditable(false);
        jTextField.setForeground(Color.red);
        jTextField.setBorder(BorderFactory.createBevelBorder(1));
        Dimension dimension = jTextField.getPreferredSize();
        dimension.width = 420;
        jTextField.setPreferredSize(dimension);
        return jTextField;
    }

    protected JComboBox createSuiteCombo() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                TestRunner.this.textChanged();
                if (keyEvent.getKeyChar() == '\n') {
                    TestRunner.this.runSuite();
                }
            }
        });
        try {
            this.loadHistory(jComboBox);
        }
        catch (IOException iOException) {}
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TestRunner.this.textChanged();
                }
            }
        });
        return jComboBox;
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected JFrame createUI(String string) {
        JPanel jPanel;
        JFrame jFrame = this.createFrame("Run Test Suite");
        JMenuBar jMenuBar = new JMenuBar();
        this.createMenus(jMenuBar);
        jFrame.setJMenuBar(jMenuBar);
        JLabel jLabel = new JLabel("Enter the name of the Test class:");
        this.fSuiteCombo = this.createSuiteCombo();
        this.fRun = this.createRunButton();
        Component component = this.createRunExtension();
        JLabel jLabel2 = new JLabel("Progress:");
        this.fProgressIndicator = new ProgressBar();
        JPanel jPanel2 = this.createCounterPanel();
        JLabel jLabel3 = new JLabel("Errors and Failures:");
        this.fFailures = new DefaultListModel();
        this.fFailureList = this.createFailureList(this.fFailures);
        JPanel jPanel3 = this.createFailedPanel();
        this.fStatusLine = this.createStatusLine();
        this.fQuitButton = this.createQuitButton();
        this.fLogo = this.createLogo();
        this.fLogo.setToolTipText("JUnit Version " + Version.id());
        JScrollPane jScrollPane = new JScrollPane(this.fFailureList, 20, 32);
        this.fPanel = jPanel = new JPanel(new GridBagLayout());
        this.addGrid(jPanel, jLabel, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(jPanel, this.fSuiteCombo, 0, 1, 1, 2, 1.0, 17);
        if (component != null) {
            this.addGrid(jPanel, component, 1, 1, 1, 0, 0.0, 17);
        }
        this.addGrid(jPanel, this.fRun, 2, 1, 1, 2, 0.0, 10);
        this.addGrid(jPanel, jLabel2, 0, 2, 2, 2, 1.0, 17);
        this.addGrid(jPanel, this.fProgressIndicator, 0, 3, 2, 2, 1.0, 17);
        this.addGrid(jPanel, this.fLogo, 2, 3, 1, 0, 0.0, 11);
        this.addGrid(jPanel, jPanel2, 0, 4, 2, 0, 0.0, 10);
        this.addGrid(jPanel, jLabel3, 0, 5, 2, 2, 1.0, 17);
        this.addGrid(jPanel, jScrollPane, 0, 6, 2, 1, 1.0, 17);
        this.addGrid(jPanel, jPanel3, 2, 6, 1, 2, 0.0, 10);
        this.addGrid(jPanel, this.fStatusLine, 0, 7, 2, 2, 1.0, 10);
        this.addGrid(jPanel, this.fQuitButton, 2, 7, 1, 2, 0.0, 10);
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        ((Component)jFrame).setLocation(200, 200);
        return jFrame;
    }

    private void doRunTest(final Test test, final boolean bl) {
        this.setButtonLabel(this.fRun, "Stop");
        this.fRunner = new Thread(){

            public void run() {
                fTestResult = this.createTestResult();
                fTestResult.addListener(this);
                this.connectTestBrowser(test, bl);
                this.start(test);
                this.postInfo("Running...");
                long l = System.currentTimeMillis();
                test.run(fTestResult);
                if (fTestResult.shouldStop()) {
                    this.postStatus("Stopped");
                } else {
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    this.postInfo("Finished: " + StringUtil.elapsedTimeAsString(l3) + " seconds");
                }
                this.setButtonLabel(fRun, "Run");
                fRunner = null;
            }
        };
        this.fRunner.start();
    }

    public void endTest(Test test) {
        this.postEndTest(test);
    }

    private File getSettingsFile() {
        String string = System.getProperty("user.home");
        Assert.assertNotNull(string);
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            return new File(string, "junit.ini");
        }
        return new File(string, ".junit");
    }

    protected String getSuiteText() {
        if (this.fSuiteCombo == null) {
            return "";
        }
        JTextField jTextField = (JTextField)this.fSuiteCombo.getEditor().getEditorComponent();
        return jTextField.getText();
    }

    protected Test getTest(String string) {
        if (string.length() <= 0) {
            this.fStatusLine.setText("");
            return null;
        }
        Class clazz = null;
        try {
            clazz = this.loadSuiteClass(string);
        }
        catch (Exception exception) {
            this.runFailed("Class \"" + string + "\" not found");
            return null;
        }
        Method method = null;
        try {
            method = clazz.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            this.fStatusLine.setText("");
            return new TestSuite(clazz);
        }
        Test test = null;
        try {
            test = (Test)method.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (Exception exception) {
            this.runFailed("Could not invoke the suite() method");
            return null;
        }
        this.fStatusLine.setText("");
        return test;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    private boolean isErrorSelected() {
        return this.fFailureList.getSelectedIndex() != -1;
    }

    private Image loadFrameIcon() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL uRL = this.getClass().getResource("smalllogo.gif");
            return toolkit.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void loadHistory(JComboBox jComboBox) throws IOException {
        BufferedReader bufferedReader;
        block3: {
            bufferedReader = new BufferedReader(new FileReader(this.getSettingsFile()));
            int n = 0;
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    jComboBox.addItem(string);
                    ++n;
                }
                if (n <= 0) break block3;
                jComboBox.setSelectedIndex(0);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                bufferedReader.close();
                throw throwable;
            }
        }
        Object var5_5 = null;
        bufferedReader.close();
    }

    protected Class loadSuiteClass(String string) throws ClassNotFoundException {
        return this.fTestLoader.load(string);
    }

    public static void main(String[] stringArray) {
        new TestRunner().start(stringArray, new StandardTestSuiteLoader());
    }

    private void postEndTest(Test test) {
        this.synchUI();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TestRunner.this.fTestResult != null) {
                    TestRunner.this.setLabelValue(TestRunner.this.fNumberOfRuns, TestRunner.this.fTestResult.runCount());
                    TestRunner.this.fProgressIndicator.step(TestRunner.this.fTestResult.wasSuccessful());
                }
            }
        });
    }

    private void postError(final Test test, final Throwable throwable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                fNumberOfErrors.setText(Integer.toString(fTestResult.errorCount()));
                this.appendFailure("Error", test, throwable);
            }
        });
    }

    private void postFailure(final Test test, final Throwable throwable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                fNumberOfFailures.setText(Integer.toString(fTestResult.failureCount()));
                this.appendFailure("Failure", test, throwable);
            }
        });
    }

    private void postInfo(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                this.showInfo(string);
            }
        });
    }

    private void postStatus(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                this.showStatus(string);
            }
        });
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    private void rerun() {
        Object object;
        Object object2;
        int n = this.fFailureList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        TestFailure testFailure = (TestFailure)this.fFailures.elementAt(n);
        Test test = testFailure.failedTest();
        if (!(test instanceof TestCase)) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        Test test2 = null;
        try {
            object2 = this.fTestLoader.reload(test.getClass());
            object = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = TestRunner.class$("java.lang.String"))};
            Object[] objectArray = new Object[]{((TestCase)test).name()};
            Constructor constructor = ((Class)object2).getConstructor((Class<?>)object);
            test2 = (Test)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        object2 = new TestResult();
        test2.run((TestResult)object2);
        object = test2.toString();
        if (((TestResult)object2).wasSuccessful()) {
            this.showInfo(String.valueOf(object) + " was successful");
        } else if (((TestResult)object2).errorCount() == 1) {
            this.showStatus(String.valueOf(object) + " had an error");
        } else {
            this.showStatus(String.valueOf(object) + " had a failure");
        }
    }

    protected void reset() {
        this.setLabelValue(this.fNumberOfErrors, 0);
        this.setLabelValue(this.fNumberOfFailures, 0);
        this.setLabelValue(this.fNumberOfRuns, 0);
        this.fProgressIndicator.reset();
        this.fShowErrorButton.setEnabled(false);
        this.fRerunButton.setEnabled(false);
        this.fFailures.clear();
    }

    public void run() {
        this.runSuite();
    }

    private void runFailed(String string) {
        this.showStatus(string);
        this.fRun.setText("Run");
        this.fRunner = null;
    }

    public synchronized void runSuite() {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            this.reset();
            this.showInfo("Load Test Case...");
            String string = this.getSuiteText();
            Test test = this.getTest(string);
            if (test != null) {
                this.addToHistory(string);
                this.doRunTest(test, true);
            }
        }
    }

    protected synchronized void runTest(Test test) {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            this.reset();
            if (test != null) {
                this.doRunTest(test, false);
            }
        }
    }

    private void saveHistory() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.getSettingsFile()));
        try {
            int n = 0;
            while (n < this.fSuiteCombo.getItemCount()) {
                String string = this.fSuiteCombo.getItemAt(n).toString();
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                ++n;
            }
        }
        finally {
            Object var3_4 = null;
            bufferedWriter.close();
        }
    }

    private void setButtonLabel(final JButton jButton, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jButton.setText(string);
            }
        });
    }

    private void setLabelValue(final JTextField jTextField, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jTextField.setText(Integer.toString(n));
            }
        });
    }

    public void setSuiteName(String string) {
        this.fSuiteCombo.addItem(string);
        this.fSuiteCombo.setSelectedItem(string);
    }

    private void showErrorTrace() {
        int n = this.fFailureList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        TestFailure testFailure = (TestFailure)this.fFailures.elementAt(n);
        Throwable throwable = testFailure.thrownException();
        if (this.fTraceFrame == null) {
            this.fTraceFrame = new TraceFrame();
            ((Component)this.fTraceFrame).setLocation(100, 100);
        }
        this.fTraceFrame.showTrace(throwable);
        ((Component)this.fTraceFrame).setVisible(true);
    }

    private void showInfo(String string) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.black);
        this.fStatusLine.setText(string);
    }

    private void showStatus(String string) {
        this.fStatusLine.setFont(BOLD_FONT);
        this.fStatusLine.setForeground(Color.red);
        this.fStatusLine.setText(string);
    }

    private void showTestBrowser() {
        String string = this.getSuiteText();
        Test test = this.getTest(string);
        if (test == null) {
            return;
        }
        if (this.fTestBrowser == null) {
            this.fTestBrowser = new TestBrowser(this);
            ((Component)this.fTestBrowser).setLocation(350, 100);
        }
        this.fTestBrowser.showTestTree(test);
        ((Component)this.fTestBrowser).setVisible(true);
    }

    private void start(final Test test) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                fProgressIndicator.start(test.countTestCases());
            }
        });
    }

    public void start(String[] stringArray, TestSuiteLoader testSuiteLoader) {
        this.fTestLoader = testSuiteLoader;
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else if (stringArray.length == 2 && stringArray[0].equals("-c")) {
            string = StringUtil.extractClassName(stringArray[1]);
        }
        this.fFrame = this.createUI(string);
        ((Component)this.fFrame).setVisible(true);
        if (string != null) {
            this.setSuiteName(string);
            this.runSuite();
        }
    }

    public void startTest(Test test) {
        this.postInfo("Running: " + test);
    }

    private void synchUI() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (Exception exception) {}
    }

    public void terminate() {
        this.fFrame.dispose();
        try {
            this.saveHistory();
        }
        catch (IOException iOException) {
            System.out.println("Couldn't save test run history");
        }
        System.exit(0);
    }

    public void textChanged() {
        this.fRun.setEnabled(this.getSuiteText().length() > 0);
        this.fStatusLine.setText("");
    }

    static class FailureListCellRenderer
    extends DefaultListCellRenderer {
        private ImageIcon fFailureIcon;
        private ImageIcon fErrorIcon;

        FailureListCellRenderer() {
            URL uRL = this.getClass().getResource("failure.gif");
            this.fFailureIcon = new ImageIcon(uRL);
            uRL = this.getClass().getResource("error.gif");
            this.fErrorIcon = new ImageIcon(uRL);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            TestFailure testFailure = (TestFailure)object;
            String string = testFailure.failedTest().toString();
            String string2 = testFailure.thrownException().getMessage();
            if (string2 != null) {
                string = String.valueOf(string) + ":" + StringUtil.truncate(string2, 200);
            }
            if (testFailure.thrownException() instanceof AssertionFailedError) {
                this.setIcon(this.fFailureIcon);
            } else {
                this.setIcon(this.fErrorIcon);
            }
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }
}

