/*
 * Decompiled with CFR 0.152.
 */
package sdsu.html;

import sdsu.html.HTML;

public class Formatter
implements HTML {
    static final String NEW_LINE = "\n<BR>";
    private String containerTypeBeginingTags = "";
    private String containerTypeEndingTags = "";
    private String alignmentBeginingTags = "";
    private String alignmentEndingTags = "";
    private StringBuffer contents = new StringBuffer();

    public Formatter() {
    }

    public Formatter(String string) {
        this.append(string);
    }

    public void alignCenter() {
        this.setAlignment("\n<CENTER>", "\n</CENTER>");
    }

    public void alignLeft() {
        this.setAlignment("\n<DIV ALIGN=left>", "\n</DIV>");
    }

    public void alignRight() {
        this.setAlignment("\n<DIV ALIGN=right>", "\n</DIV>");
    }

    public void append(String string) {
        this.contents.append(Formatter.encodeText(string));
    }

    public void append(HTML hTML) {
        this.contents.append(hTML.toString());
    }

    public void appendBold(String string) {
        this.contents.append("\n<B>");
        this.contents.append(Formatter.encodeText(string));
        this.contents.append("\n</B>");
    }

    public void appendHTMLTags(String string) {
        this.contents.append(string);
    }

    public void appendHeading(String string, int n) {
        String string2 = "";
        String string3 = "";
        switch (n) {
            case 1: {
                string2 = "\n<H1>";
                string3 = "\n</H1>";
                break;
            }
            case 2: {
                string2 = "\n<H2>";
                string3 = "\n</H2>";
                break;
            }
            case 3: {
                string2 = "\n<H3>";
                string3 = "\n</H3>";
                break;
            }
            case 4: {
                string2 = "\n<H4>";
                string3 = "\n</H4>";
                break;
            }
            case 5: {
                string2 = "\n<H5>";
                string3 = "\n</H5>";
                break;
            }
            case 6: {
                string2 = "\n<H6>";
                string3 = "\n</H6>";
                break;
            }
        }
        this.contents.append(string2);
        this.contents.append(Formatter.encodeText(string));
        this.contents.append(string3);
    }

    public void appendItalic(String string) {
        this.contents.append("\n<I>");
        this.contents.append(Formatter.encodeText(string));
        this.contents.append("\n</I>");
    }

    public void appendLineBreak() {
        this.contents.append(NEW_LINE);
    }

    public void appendLink(String string, String string2) {
        this.contents.append("<A HREF=\"");
        this.contents.append(string2);
        this.contents.append("\">");
        this.contents.append(Formatter.encodeText(string));
        this.contents.append("</A>");
    }

    public void appendMailLink(String string) {
        this.contents.append("<A HREF=\"mailto:");
        this.contents.append(string);
        this.contents.append("\">");
        this.contents.append(string);
        this.contents.append("</A>");
    }

    static final String encodeText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void makeBlockQuote() {
        this.setContainerType("\n<BLOCKQUOTE>", "\n</BLOCKQUOTE>");
    }

    public void makeParagraph() {
        this.setContainerType("\n<P>", "\n</P>");
    }

    public void makePreformatted() {
        this.setContainerType("\n<PRE>", "\n</PRE>");
    }

    private void setAlignment(String string, String string2) {
        this.alignmentBeginingTags = string;
        this.alignmentEndingTags = string2;
    }

    private void setContainerType(String string, String string2) {
        this.containerTypeBeginingTags = string;
        this.containerTypeEndingTags = string2;
    }

    public String toString() {
        return String.valueOf(this.alignmentBeginingTags) + this.containerTypeBeginingTags + this.contents.toString() + this.containerTypeEndingTags + this.alignmentEndingTags;
    }
}

