/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import sdsu.io.ChunkEnumerator;
import sdsu.util.LabeledData;
import sdsu.util.Stringizable;

public class StringizedDataEnumerator
implements Enumeration {
    public static final String META_SEPARATOR_KEY = "DataSeparator";
    public static final String META_COMMENT_CHAR_KEY = "CommentCharacter";
    public static final String META_DATA_CHAR_KEY = "MetaDataCharacter";
    public static final char DEFAULT_COMMENT_CHAR = '#';
    public static final char DEFAULT_METADATA_CHAR = '$';
    public static final String DEFAULT_DATA_BLOCK_SEPARATOR = "@DataBlockSeparator@";
    protected ChunkEnumerator rawData;
    protected String metaDataComment;
    protected String dataComment;
    protected LabeledData metaData;
    protected Object data;
    private char commentChar = (char)35;
    private char metaDataChar = (char)36;
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final int EOF = -1;

    public StringizedDataEnumerator(Reader reader) throws IOException {
        String string = DEFAULT_DATA_BLOCK_SEPARATOR;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.removeWhiteSpace(bufferedReader);
        if (this.startsWith(bufferedReader, this.commentChar, this.commentChar)) {
            bufferedReader.read();
            bufferedReader.read();
            LabeledData labeledData = new LabeledData();
            labeledData.fromString(bufferedReader.readLine());
            string = labeledData.getData(META_SEPARATOR_KEY, DEFAULT_DATA_BLOCK_SEPARATOR);
            if (((Hashtable)labeledData).containsKey(META_COMMENT_CHAR_KEY)) {
                this.commentChar = labeledData.getData(META_COMMENT_CHAR_KEY).charAt(0);
            }
            if (((Hashtable)labeledData).containsKey(META_DATA_CHAR_KEY)) {
                this.metaDataChar = labeledData.getData(META_DATA_CHAR_KEY).charAt(0);
            }
        }
        this.rawData = new ChunkEnumerator(bufferedReader, string);
    }

    public StringizedDataEnumerator(String string) throws IOException {
        this(new StringReader(string));
    }

    protected String extractComment(BufferedReader bufferedReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.startsCommentLine(bufferedReader)) {
            stringBuffer.append(bufferedReader.readLine());
            stringBuffer.append(lineSeparator);
        }
        if (stringBuffer.length() >= lineSeparator.length()) {
            stringBuffer.setLength(stringBuffer.length() - lineSeparator.length());
        }
        return stringBuffer.toString();
    }

    protected String extractData(BufferedReader bufferedReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = bufferedReader.read();
        while (n != -1) {
            stringBuffer.append((char)n);
            n = bufferedReader.read();
        }
        return stringBuffer.toString();
    }

    protected LabeledData extractMetaData(BufferedReader bufferedReader) throws IOException {
        LabeledData labeledData = new LabeledData();
        StringBuffer stringBuffer = new StringBuffer();
        while (this.startsMetaDataLine(bufferedReader)) {
            bufferedReader.read();
            bufferedReader.read();
            stringBuffer.append(bufferedReader.readLine());
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        labeledData.fromString(stringBuffer.toString());
        return labeledData;
    }

    public static StringizedDataEnumerator fromFile(String string) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader, 8000);
        return new StringizedDataEnumerator(bufferedReader);
    }

    public String getDataComment() {
        return this.dataComment;
    }

    public String getDataLabel() {
        if (this.metaData != null) {
            return this.metaData.getData("Label", "");
        }
        return "";
    }

    public String getMetaDataComment() {
        return this.metaDataComment;
    }

    public boolean hasMoreElements() {
        return this.rawData.hasMoreElements();
    }

    public Object nextElement() {
        try {
            String string = (String)this.rawData.nextElement();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            this.removeWhiteSpace(bufferedReader);
            this.metaDataComment = this.extractComment(bufferedReader);
            this.removeWhiteSpace(bufferedReader);
            this.metaData = this.extractMetaData(bufferedReader);
            this.removeWhiteSpace(bufferedReader);
            this.dataComment = this.extractComment(bufferedReader);
            String string2 = this.extractData(bufferedReader);
            if (!((Hashtable)this.metaData).containsKey("class")) {
                return string2;
            }
            String string3 = this.metaData.getData("class");
            Stringizable stringizable = (Stringizable)Class.forName(string3).newInstance();
            stringizable.setMetaData(this.metaData);
            stringizable.fromString(string2);
            return stringizable;
        }
        catch (Exception exception) {
            throw new NoSuchElementException("Error in reading input: " + exception.getMessage());
        }
    }

    protected void removeWhiteSpace(BufferedReader bufferedReader) throws IOException {
        bufferedReader.mark(1);
        int n = bufferedReader.read();
        while (n == 32 || n == 9 || n == 10 || n == 13) {
            bufferedReader.mark(1);
            n = bufferedReader.read();
        }
        if (n == -1) {
            return;
        }
        bufferedReader.reset();
    }

    public void setSeparator(String string) {
        this.rawData.setSeparator(string);
    }

    protected boolean startsCommentLine(BufferedReader bufferedReader) throws IOException {
        return this.startsWith(bufferedReader, this.commentChar) && !this.startsMetaDataLine(bufferedReader);
    }

    protected boolean startsMetaDataLine(BufferedReader bufferedReader) throws IOException {
        return this.startsWith(bufferedReader, this.commentChar, this.metaDataChar);
    }

    protected boolean startsWith(BufferedReader bufferedReader, char c) throws IOException {
        bufferedReader.mark(1);
        int n = bufferedReader.read();
        if (n == -1) {
            return false;
        }
        bufferedReader.reset();
        return n == c;
    }

    protected boolean startsWith(BufferedReader bufferedReader, char c, char c2) throws IOException {
        bufferedReader.mark(2);
        int n = bufferedReader.read();
        if (n == -1) {
            return false;
        }
        int n2 = bufferedReader.read();
        bufferedReader.reset();
        return n == c && n2 == c2;
    }
}

