/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import sdsu.util.LabeledData;

public class TokenCharacters
implements Serializable {
    private static final String EOL = "\r\n";
    public static final String WHITESPACE = " \t\r\n";
    public static final char ESCAPE_CHAR = '\\';
    public static final String COMMENT_CHAR = "#";
    public static final char QUOTE_CHAR = '\'';
    private String whitespace;
    private String commentChars;
    private String beginQuoteChars;
    private String endQuoteChars;
    private String separators;
    private static final int NOT_FOUND = -1;

    public TokenCharacters() {
        this("");
    }

    public TokenCharacters(String string) {
        this(string, COMMENT_CHAR, '\'', '\'', WHITESPACE);
    }

    public TokenCharacters(String string, String string2, char c, char c2, String string3) {
        this.separators = this.nullFilter(string);
        this.commentChars = this.nullFilter(string2);
        this.whitespace = this.nullFilter(string3);
        this.beginQuoteChars = String.valueOf(c);
        this.endQuoteChars = String.valueOf(c2);
        this.makeDisjointWhiteSpaceAndSeperators();
    }

    public void addQuoteChars(char c, char c2) {
        this.beginQuoteChars = String.valueOf(this.beginQuoteChars) + c;
        this.endQuoteChars = String.valueOf(this.endQuoteChars) + c2;
    }

    private static final boolean containsChar(String string, char c) {
        return string.indexOf(c) != -1;
    }

    private static final boolean containsChar(String string, String string2) {
        int n = 0;
        while (n < string2.length()) {
            if (string.indexOf(string2.charAt(n)) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsEscapeableChar(String string) {
        String string2 = String.valueOf(this.beginQuoteChars) + this.endQuoteChars + '\\';
        return TokenCharacters.containsChar(string, string2);
    }

    public boolean containsTokenTerminator(String string) {
        String string2 = String.valueOf(this.whitespace) + this.commentChars + this.separators;
        return TokenCharacters.containsChar(string, string2);
    }

    public String escapeToken(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        String string2 = String.valueOf(this.beginQuoteChars) + this.endQuoteChars + '\\';
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (TokenCharacters.containsChar(string2, c)) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void fromLabeledData(LabeledData labeledData) {
        this.whitespace = labeledData.getData("whitespace", WHITESPACE);
        this.commentChars = labeledData.getData("commentChars", COMMENT_CHAR);
        String string = String.valueOf('\'');
        this.beginQuoteChars = labeledData.getData("beginQuoteChars", string);
        this.endQuoteChars = labeledData.getData("endQuoteChars", string);
        this.separators = labeledData.getData("separators", "");
        this.makeDisjointWhiteSpaceAndSeperators();
    }

    public void fromString(String string) throws IOException {
        LabeledData labeledData = new LabeledData();
        labeledData.fromString(string);
        this.fromLabeledData(labeledData);
    }

    public char getCommentChar() {
        return this.commentChars.charAt(0);
    }

    public boolean isBeginQuote(char c) {
        return TokenCharacters.containsChar(this.beginQuoteChars, c);
    }

    public boolean isComment(char c) {
        return TokenCharacters.containsChar(this.commentChars, c);
    }

    public boolean isEOL(char c) {
        return TokenCharacters.containsChar(EOL, c);
    }

    public boolean isEndQuote(char c) {
        return TokenCharacters.containsChar(this.endQuoteChars, c);
    }

    public boolean isEscape(char c) {
        return c == '\\';
    }

    public boolean isQuotePair(char c, char c2) {
        int n = this.beginQuoteChars.indexOf(c);
        if (n == -1) {
            return false;
        }
        return this.endQuoteChars.charAt(n) == c2;
    }

    public boolean isSeparator(char c) {
        return TokenCharacters.containsChar(this.separators, c);
    }

    public boolean isTokenTerminator(char c) {
        return TokenCharacters.containsChar(String.valueOf(this.whitespace) + this.separators + this.commentChars, c);
    }

    public boolean isWhitespace(char c) {
        return TokenCharacters.containsChar(this.whitespace, c);
    }

    private void makeDisjointWhiteSpaceAndSeperators() {
        int n = 0;
        while (n < this.whitespace.length()) {
            if (TokenCharacters.containsChar(this.separators, this.whitespace.charAt(n))) {
                this.whitespace = TokenCharacters.remove(this.whitespace, this.whitespace.charAt(n));
            }
            ++n;
        }
    }

    private String nullFilter(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public String quoteToken(String string) {
        return String.valueOf(this.beginQuoteChars.charAt(0)) + string + this.endQuoteChars.charAt(0);
    }

    private static final String remove(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (c != string.charAt(n)) {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean requiresEscaping(char c) {
        return TokenCharacters.containsChar(String.valueOf(this.beginQuoteChars) + this.endQuoteChars + '\\', c);
    }

    public void setSeparatorChars(String string) {
        this.separators = this.nullFilter(string);
        this.makeDisjointWhiteSpaceAndSeperators();
    }

    public LabeledData toLabeledData() {
        String string;
        LabeledData labeledData = new LabeledData();
        if (!this.whitespace.equals(WHITESPACE)) {
            ((Hashtable)labeledData).put("whitespace", this.whitespace);
        }
        if (!this.commentChars.equals(COMMENT_CHAR)) {
            ((Hashtable)labeledData).put("commentChars", this.commentChars);
        }
        if (!this.beginQuoteChars.equals(string = String.valueOf('\''))) {
            ((Hashtable)labeledData).put("beginQuoteChars", this.beginQuoteChars);
        }
        if (!this.endQuoteChars.equals(string)) {
            ((Hashtable)labeledData).put("endQuoteChars", this.endQuoteChars);
        }
        if (this.separators.length() > 0) {
            ((Hashtable)labeledData).put("separators", this.separators);
        }
        return labeledData;
    }
}

