/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics.fate;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.master.metrics.fate.FateMetricSnapshot;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FateHadoop2Metrics
implements Metrics,
MetricsSource {
    private static final Logger log = LoggerFactory.getLogger(FateHadoop2Metrics.class);
    private static final long DEFAULT_MIN_REFRESH_DELAY = TimeUnit.SECONDS.toMillis(10L);
    private volatile long minimumRefreshDelay;
    public static final String NAME = "Master,sub=Fate";
    public static final String DESCRIPTION = "Fate Metrics";
    public static final String CONTEXT = "master";
    public static final String RECORD = "fate";
    public static final String CUR_FATE_OPS = "currentFateOps";
    public static final String TOTAL_FATE_OPS = "totalFateOps";
    public static final String TOTAL_ZK_CONN_ERRORS = "totalZkConnErrors";
    private static final String FATE_TX_STATE_METRIC_PREFIX = "FateTxState_";
    private static final String FATE_OP_TYPE_METRIC_PREFIX = "FateTxOpType_";
    private final MutableGaugeLong currentFateOps;
    private final MutableGaugeLong zkChildFateOpsTotal;
    private final MutableGaugeLong zkConnectionErrorsTotal;
    private final Map<String, MutableGaugeLong> fateTypeCounts = new TreeMap<String, MutableGaugeLong>();
    private final Map<String, MutableGaugeLong> fateOpCounts = new TreeMap<String, MutableGaugeLong>();
    private FateMetricSnapshot metricSnapshot;
    private final String instanceId;
    private final MetricsSystem metricsSystem;
    private final MetricsRegistry registry;
    private final Lock metricsValuesLock = new ReentrantLock();
    private volatile long lastUpdate = 0L;
    private final ZooReaderWriter zoo;

    public FateHadoop2Metrics(String instanceId, MetricsSystem metricsSystem, long minimumRefreshDelay) {
        this.instanceId = instanceId;
        this.zoo = ZooReaderWriter.getInstance();
        this.minimumRefreshDelay = Math.max(DEFAULT_MIN_REFRESH_DELAY, minimumRefreshDelay);
        this.metricsSystem = metricsSystem;
        this.registry = new MetricsRegistry(Interns.info((String)NAME, (String)DESCRIPTION));
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, MetricsSystemHelper.getProcessName());
        this.currentFateOps = this.registry.newGauge(CUR_FATE_OPS, "Current number of FATE Ops", 0L);
        this.zkChildFateOpsTotal = this.registry.newGauge(TOTAL_FATE_OPS, "Total FATE Ops", 0L);
        this.zkConnectionErrorsTotal = this.registry.newGauge(TOTAL_ZK_CONN_ERRORS, "Total ZK Connection Errors", 0L);
    }

    void overrideRefresh(long minimumRefreshDelay) {
        long delay = Math.max(0L, minimumRefreshDelay);
        this.minimumRefreshDelay = TimeUnit.SECONDS.toMillis(delay);
    }

    public void register() {
        this.metricsSystem.register(NAME, DESCRIPTION, (Object)this);
    }

    public void add(String name, long time) {
        throw new UnsupportedOperationException("add() is not implemented");
    }

    public boolean isEnabled() {
        return true;
    }

    protected void prepareMetrics() {
        this.metricsValuesLock.lock();
        try {
            long now = System.currentTimeMillis();
            if (this.lastUpdate + this.minimumRefreshDelay < now) {
                log.trace("Update fate metrics, lastUpdate: {}, now {}", (Object)this.lastUpdate, (Object)now);
                this.metricSnapshot = FateMetricSnapshot.getFromZooKeeper(this.instanceId, (org.apache.accumulo.fate.zookeeper.ZooReaderWriter)this.zoo);
                this.lastUpdate = now;
                this.recordValues();
            }
        }
        finally {
            this.metricsValuesLock.unlock();
        }
    }

    private void recordValues() {
        this.currentFateOps.set(this.metricSnapshot.getCurrentFateOps());
        this.zkChildFateOpsTotal.set(this.metricSnapshot.getZkFateChildOpsTotal());
        this.zkConnectionErrorsTotal.set(this.metricSnapshot.getZkConnectionErrors());
        Map<String, Long> states = this.metricSnapshot.getTxStateCounters();
        states.forEach((key, value) -> this.fateTypeCounts.computeIfAbsent((String)key, v -> this.registry.newGauge(this.metricNameHelper(FATE_TX_STATE_METRIC_PREFIX, (String)key), "By transaction state count for " + key, value.longValue())).set(value.longValue()));
        this.fateOpCounts.forEach((key, value) -> value.set(0L));
        Map<String, Long> opTypes = this.metricSnapshot.getOpTypeCounters();
        log.trace("OP Counts Before: prev {}, updates {}", this.fateOpCounts, opTypes);
        opTypes.forEach((key, value) -> this.fateOpCounts.computeIfAbsent((String)key, guage -> this.registry.newGauge(this.metricNameHelper(FATE_OP_TYPE_METRIC_PREFIX, (String)key), "By transaction op type count for " + key, value.longValue())).set(value.longValue()));
        log.trace("OP Counts After: prev {}, updates {}", this.fateOpCounts, opTypes);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        this.prepareMetrics();
        this.recordValues();
        MetricsRecordBuilder builder = collector.addRecord(RECORD).setContext(CONTEXT);
        this.registry.snapshot(builder, all);
    }

    private String metricNameHelper(String prefix, String name) {
        return prefix + name;
    }
}

