/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin;

import java.io.Serializable;
import java.util.Objects;

public final class MountVolumeSpec
implements Serializable,
Comparable {
    private static final long serialVersionUID = 2479676805545997492L;
    private final String hostPath;
    private final String mountPath;
    private final Boolean isReadOnly;
    public static final String READONLYOPTION = "ro";

    private MountVolumeSpec(Builder builder) {
        this.hostPath = builder.hostPath;
        this.mountPath = builder.mountPath;
        this.isReadOnly = builder.isReadOnly;
    }

    public String getHostPath() {
        return this.hostPath;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public Boolean getReadOnly() {
        return this.isReadOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MountVolumeSpec other = (MountVolumeSpec)o;
        return Objects.equals(this.hostPath, other.getHostPath()) && Objects.equals(this.mountPath, other.getMountPath()) && Objects.equals(this.isReadOnly, other.getReadOnly());
    }

    public int hashCode() {
        return Objects.hash(this.hostPath, this.mountPath, this.isReadOnly);
    }

    public int compareTo(Object o) {
        return 0;
    }

    public static final class Builder {
        private String hostPath;
        private String mountPath;
        private Boolean isReadOnly;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public MountVolumeSpec build() {
            return new MountVolumeSpec(this);
        }

        public Builder setHostPath(String hPath) {
            this.hostPath = hPath;
            return this;
        }

        public Builder setMountPath(String mPath) {
            this.mountPath = mPath;
            return this;
        }

        public Builder setReadOnly(Boolean readOnly) {
            this.isReadOnly = readOnly;
            return this;
        }
    }
}

