/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.OutboundBandwidthResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TrafficControlBandwidthHandlerImpl
implements OutboundBandwidthResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficControlBandwidthHandlerImpl.class);
    private static final int MAX_CONTAINER_COUNT = 50;
    private final PrivilegedOperationExecutor privilegedOperationExecutor;
    private final CGroupsHandler cGroupsHandler;
    private final TrafficController trafficController;
    private final ConcurrentHashMap<ContainerId, Integer> containerIdClassIdMap;
    private Configuration conf;
    private String device;
    private boolean strictMode;
    private int containerBandwidthMbit;
    private int rootBandwidthMbit;
    private int yarnBandwidthMbit;

    public TrafficControlBandwidthHandlerImpl(PrivilegedOperationExecutor privilegedOperationExecutor, CGroupsHandler cGroupsHandler, TrafficController trafficController) {
        this.privilegedOperationExecutor = privilegedOperationExecutor;
        this.cGroupsHandler = cGroupsHandler;
        this.trafficController = trafficController;
        this.containerIdClassIdMap = new ConcurrentHashMap();
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration configuration) throws ResourceHandlerException {
        this.conf = configuration;
        this.cGroupsHandler.initializeCGroupController(CGroupsHandler.CGroupController.NET_CLS);
        this.device = this.conf.get("yarn.nodemanager.resource.network.interface", "eth0");
        this.strictMode = configuration.getBoolean("yarn.nodemanager.linux-container-executor.cgroups.strict-resource-usage", false);
        this.rootBandwidthMbit = this.conf.getInt("yarn.nodemanager.resource.network.outbound-bandwidth-mbit", 1000);
        this.yarnBandwidthMbit = this.conf.getInt("yarn.nodemanager.resource.network.outbound-bandwidth-yarn-mbit", this.rootBandwidthMbit);
        this.containerBandwidthMbit = (int)Math.ceil((double)this.yarnBandwidthMbit / 50.0);
        StringBuffer logLine = new StringBuffer("strict mode is set to :").append(this.strictMode).append(System.lineSeparator());
        if (this.strictMode) {
            logLine.append("container bandwidth will be capped to soft limit.").append(System.lineSeparator());
        } else {
            logLine.append("containers will be allowed to use spare YARN bandwidth.").append(System.lineSeparator());
        }
        logLine.append("containerBandwidthMbit soft limit (in mbit/sec) is set to : ").append(this.containerBandwidthMbit);
        LOG.info(logLine.toString());
        this.trafficController.bootstrap(this.device, this.rootBandwidthMbit, this.yarnBandwidthMbit);
        return null;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        String containerIdStr = container.getContainerId().toString();
        int classId = this.trafficController.getNextClassId();
        String classIdStr = this.trafficController.getStringForNetClsClassId(classId);
        this.cGroupsHandler.createCGroup(CGroupsHandler.CGroupController.NET_CLS, containerIdStr);
        this.cGroupsHandler.updateCGroupParam(CGroupsHandler.CGroupController.NET_CLS, containerIdStr, "classid", classIdStr);
        this.containerIdClassIdMap.put(container.getContainerId(), classId);
        String tasksFile = this.cGroupsHandler.getPathForCGroupTasks(CGroupsHandler.CGroupController.NET_CLS, containerIdStr);
        String opArg = new StringBuffer("cgroups=").append(tasksFile).toString();
        ArrayList<PrivilegedOperation> ops = new ArrayList<PrivilegedOperation>();
        ops.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, opArg));
        TrafficController trafficController = this.trafficController;
        trafficController.getClass();
        TrafficController.BatchBuilder builder = trafficController.new TrafficController.BatchBuilder(PrivilegedOperation.OperationType.TC_MODIFY_STATE);
        builder.addContainerClass(classId, this.containerBandwidthMbit, this.strictMode);
        ops.add(builder.commitBatchToTempFile());
        return ops;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        String containerIdStr = containerId.toString();
        LOG.debug("Attempting to reacquire classId for container: {}", (Object)containerIdStr);
        String classIdStrFromFile = this.cGroupsHandler.getCGroupParam(CGroupsHandler.CGroupController.NET_CLS, containerIdStr, "classid");
        int classId = this.trafficController.getClassIdFromFileContents(classIdStrFromFile);
        LOG.info("Reacquired containerId -> classId mapping: " + containerIdStr + " -> " + classId);
        this.containerIdClassIdMap.put(containerId, classId);
        return null;
    }

    @Override
    public List<PrivilegedOperation> updateContainer(Container container) throws ResourceHandlerException {
        return null;
    }

    public Map<ContainerId, Integer> getBytesSentPerContainer() throws ResourceHandlerException {
        Map<Integer, Integer> classIdStats = this.trafficController.readStats();
        HashMap<ContainerId, Integer> containerIdStats = new HashMap<ContainerId, Integer>();
        for (Map.Entry<ContainerId, Integer> entry : this.containerIdClassIdMap.entrySet()) {
            ContainerId containerId = entry.getKey();
            Integer classId = entry.getValue();
            Integer bytesSent = classIdStats.get(classId);
            if (bytesSent == null) {
                LOG.warn("No bytes sent metric found for container: " + containerId + " with classId: " + classId);
                continue;
            }
            containerIdStats.put(containerId, bytesSent);
        }
        return containerIdStats;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        LOG.info("postComplete for container: " + containerId.toString());
        this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.NET_CLS, containerId.toString());
        Integer classId = this.containerIdClassIdMap.get(containerId);
        if (classId != null) {
            TrafficController trafficController = this.trafficController;
            trafficController.getClass();
            PrivilegedOperation op = trafficController.new TrafficController.BatchBuilder(PrivilegedOperation.OperationType.TC_MODIFY_STATE).deleteContainerClass(classId).commitBatchToTempFile();
            try {
                this.privilegedOperationExecutor.executePrivilegedOperation(op, false);
                this.trafficController.releaseClassId(classId);
            }
            catch (PrivilegedOperationException e) {
                LOG.warn("Failed to delete tc rule for classId: " + classId);
                throw new ResourceHandlerException("Failed to delete tc rule for classId:" + classId);
            }
        } else {
            LOG.warn("Not cleaning up tc rules. classId unknown for container: " + containerId.toString());
        }
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        LOG.debug("teardown(): Nothing to do");
        return null;
    }

    public String toString() {
        return TrafficControlBandwidthHandlerImpl.class.getName();
    }
}

