/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourcesExceptionUtil;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu.GpuResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.OCIContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpuResourceHandlerImpl
implements ResourceHandler {
    static final Logger LOG = LoggerFactory.getLogger(GpuResourceHandlerImpl.class);
    public static final String EXCLUDED_GPUS_CLI_OPTION = "--excluded_gpus";
    public static final String CONTAINER_ID_CLI_OPTION = "--container_id";
    private final Context nmContext;
    private final GpuResourceAllocator gpuAllocator;
    private final CGroupsHandler cGroupsHandler;
    private final PrivilegedOperationExecutor privilegedOperationExecutor;
    private final GpuDiscoverer gpuDiscoverer;

    public GpuResourceHandlerImpl(Context nmContext, CGroupsHandler cGroupsHandler, PrivilegedOperationExecutor privilegedOperationExecutor, GpuDiscoverer gpuDiscoverer) {
        this.nmContext = nmContext;
        this.cGroupsHandler = cGroupsHandler;
        this.privilegedOperationExecutor = privilegedOperationExecutor;
        this.gpuAllocator = new GpuResourceAllocator(nmContext);
        this.gpuDiscoverer = gpuDiscoverer;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration configuration) throws ResourceHandlerException {
        List<GpuDevice> usableGpus;
        try {
            usableGpus = this.gpuDiscoverer.getGpusUsableByYarn();
            if (usableGpus == null || usableGpus.isEmpty()) {
                String message = "GPU is enabled on the NodeManager, but couldn't find any usable GPU devices, please double check configuration!";
                LOG.error(message);
                ResourcesExceptionUtil.throwIfNecessary(new ResourceHandlerException(message), configuration);
            }
        }
        catch (YarnException e) {
            LOG.error("Exception when trying to get usable GPU device", (Throwable)e);
            throw new ResourceHandlerException(e);
        }
        for (GpuDevice gpu : usableGpus) {
            this.gpuAllocator.addGpu(gpu);
        }
        this.cGroupsHandler.initializeCGroupController(CGroupsHandler.CGroupController.DEVICES);
        return null;
    }

    @Override
    public synchronized List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        String containerIdStr = container.getContainerId().toString();
        GpuResourceAllocator.GpuAllocation allocation = this.gpuAllocator.assignGpus(container);
        this.cGroupsHandler.createCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
        if (!OCIContainerRuntime.isOCICompliantContainerRequested(this.nmContext.getConf(), container.getLaunchContext().getEnvironment())) {
            try {
                PrivilegedOperation privilegedOperation = new PrivilegedOperation(PrivilegedOperation.OperationType.GPU, Arrays.asList(CONTAINER_ID_CLI_OPTION, containerIdStr));
                if (!allocation.getDeniedGPUs().isEmpty()) {
                    ArrayList<Integer> minorNumbers = new ArrayList<Integer>();
                    for (GpuDevice deniedGpu : allocation.getDeniedGPUs()) {
                        minorNumbers.add(deniedGpu.getMinorNumber());
                    }
                    privilegedOperation.appendArgs(Arrays.asList(EXCLUDED_GPUS_CLI_OPTION, StringUtils.join((CharSequence)",", minorNumbers)));
                }
                this.privilegedOperationExecutor.executePrivilegedOperation(privilegedOperation, true);
            }
            catch (PrivilegedOperationException e) {
                this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
                LOG.warn("Could not update cgroup for container", (Throwable)((Object)e));
                throw new ResourceHandlerException((Throwable)((Object)e));
            }
            ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
            ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(CGroupsHandler.CGroupController.DEVICES, containerIdStr)));
            return ret;
        }
        return null;
    }

    public GpuResourceAllocator getGpuAllocator() {
        return this.gpuAllocator;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        this.gpuAllocator.recoverAssignedGpus(containerId);
        return null;
    }

    @Override
    public List<PrivilegedOperation> updateContainer(Container container) throws ResourceHandlerException {
        return null;
    }

    @Override
    public synchronized List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.gpuAllocator.unassignGpus(containerId);
        this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    public String toString() {
        return GpuResourceHandlerImpl.class.getName() + "{gpuAllocator=" + this.gpuAllocator + '}';
    }
}

