/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.htrace.fasterxml.jackson.core.JsonGenerationException;
import org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.fasterxml.jackson.databind.JavaType;
import org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import org.apache.htrace.fasterxml.jackson.databind.JsonNode;
import org.apache.htrace.fasterxml.jackson.databind.JsonSerializable;
import org.apache.htrace.fasterxml.jackson.databind.ObjectMapper;
import org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.htrace.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.htrace.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import org.apache.htrace.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.htrace.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.htrace.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.htrace.fasterxml.jackson.databind.type.TypeFactory;

@JacksonStdImpl
public class SerializableSerializer
extends StdSerializer<JsonSerializable> {
    public static final SerializableSerializer instance = new SerializableSerializer();
    private static final AtomicReference<ObjectMapper> _mapperReference = new AtomicReference();

    protected SerializableSerializer() {
        super(JsonSerializable.class);
    }

    @Override
    public void serialize(JsonSerializable value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        value.serialize(jgen, provider);
    }

    @Override
    public final void serializeWithType(JsonSerializable value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        value.serializeWithType(jgen, provider, typeSer);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Class<?> rawClass;
        ObjectNode objectNode = this.createObjectNode();
        String schemaType = "any";
        String objectProperties = null;
        String itemDefinition = null;
        if (typeHint != null && (rawClass = TypeFactory.rawClass(typeHint)).isAnnotationPresent(JsonSerializableSchema.class)) {
            JsonSerializableSchema schemaInfo = rawClass.getAnnotation(JsonSerializableSchema.class);
            schemaType = schemaInfo.schemaType();
            if (!"##irrelevant".equals(schemaInfo.schemaObjectPropertiesDefinition())) {
                objectProperties = schemaInfo.schemaObjectPropertiesDefinition();
            }
            if (!"##irrelevant".equals(schemaInfo.schemaItemDefinition())) {
                itemDefinition = schemaInfo.schemaItemDefinition();
            }
        }
        objectNode.put("type", schemaType);
        if (objectProperties != null) {
            try {
                objectNode.put("properties", SerializableSerializer._getObjectMapper().readTree(objectProperties));
            }
            catch (IOException e) {
                throw new JsonMappingException("Failed to parse @JsonSerializableSchema.schemaObjectPropertiesDefinition value");
            }
        }
        if (itemDefinition != null) {
            try {
                objectNode.put("items", SerializableSerializer._getObjectMapper().readTree(itemDefinition));
            }
            catch (IOException e) {
                throw new JsonMappingException("Failed to parse @JsonSerializableSchema.schemaItemDefinition value");
            }
        }
        return objectNode;
    }

    private static final synchronized ObjectMapper _getObjectMapper() {
        ObjectMapper mapper = _mapperReference.get();
        if (mapper == null) {
            mapper = new ObjectMapper();
            _mapperReference.set(mapper);
        }
        return mapper;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }
}

