/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.CustomRequestLog;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.RequestLog;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class HttpRequestLog {
    private static final ImmutableMap<String, String> SERVER_TO_COMPONENT = ImmutableMap.of("master", "master", "region", "regionserver");

    public static RequestLog getRequestLog(String name) {
        String lookup = SERVER_TO_COMPONENT.get(name);
        if (lookup != null) {
            name = lookup;
        }
        String loggerName = "http.requests." + name;
        Slf4jRequestLogWriter writer = new Slf4jRequestLogWriter();
        writer.setLoggerName(loggerName);
        return new CustomRequestLog(writer, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"");
    }

    private HttpRequestLog() {
    }
}

