/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefinedSetFilterScanLabelGenerator
implements ScanLabelGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DefinedSetFilterScanLabelGenerator.class);
    private Configuration conf;
    private VisibilityLabelsCache labelsCache = VisibilityLabelsCache.get();

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public List<String> getLabels(User user, Authorizations authorizations) {
        if (authorizations != null) {
            List labels = authorizations.getLabels();
            String userName = user.getShortName();
            HashSet<String> auths = new HashSet<String>();
            auths.addAll(this.labelsCache.getUserAuths(userName));
            auths.addAll(this.labelsCache.getGroupAuths(user.getGroupNames()));
            return this.dropLabelsNotInUserAuths(labels, new ArrayList<String>(auths), userName);
        }
        return null;
    }

    private List<String> dropLabelsNotInUserAuths(List<String> labels, List<String> auths, String userName) {
        ArrayList<String> droppedLabels = new ArrayList<String>();
        ArrayList<String> passedLabels = new ArrayList<String>(labels.size());
        for (String label : labels) {
            if (auths.contains(label)) {
                passedLabels.add(label);
                continue;
            }
            droppedLabels.add(label);
        }
        if (!droppedLabels.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Dropping invalid authorizations requested by user ");
            sb.append(userName);
            sb.append(": [ ");
            for (String label : droppedLabels) {
                sb.append(label);
                sb.append(' ');
            }
            sb.append(']');
            LOG.warn(sb.toString());
        }
        return passedLabels;
    }
}

